/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.OrderedDependencyVisitor;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.HashMap;
import java.util.List;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

class DependencyTreeConflictResolver {
    final OrderedDependencyVisitor visitor;

    static void resolveConflicts(DependencyNode root) {
        new DependencyTreeConflictResolver(root).run();
    }

    private DependencyTreeConflictResolver(DependencyNode root) {
        this.visitor = new OrderedDependencyVisitor(root);
    }

    private void run() {
        this.visitor.next();
        HashMap<ArtifactKey, VisitedDependency> visited = new HashMap<ArtifactKey, VisitedDependency>();
        while (this.visitor.hasNext()) {
            DependencyNode node = this.visitor.next();
            if (DependencyUtils.hasWinner(node)) continue;
            visited.compute(DependencyUtils.getKey(node.getArtifact()), this::resolveConflict);
        }
    }

    private VisitedDependency resolveConflict(ArtifactKey key, VisitedDependency prev) {
        if (prev == null) {
            return new VisitedDependency(this.visitor);
        }
        prev.resolveConflict(this.visitor);
        return prev;
    }

    private static int getScopePriority(String scope) {
        return switch (scope) {
            case "compile" -> 0;
            case "runtime" -> 1;
            case "provided" -> 2;
            case "test" -> 3;
            default -> 4;
        };
    }

    private static class VisitedDependency {
        final DependencyNode node;
        final int subtreeIndex;

        private VisitedDependency(OrderedDependencyVisitor visitor) {
            this.node = visitor.getCurrent();
            this.subtreeIndex = visitor.getSubtreeIndex();
        }

        private void resolveConflict(OrderedDependencyVisitor visitor) {
            DependencyNode otherNode = visitor.getCurrent();
            if (this.subtreeIndex != visitor.getSubtreeIndex()) {
                Dependency currentDep = this.node.getDependency();
                Dependency otherDep = otherNode.getDependency();
                if (!currentDep.getScope().equals(otherDep.getScope()) && DependencyTreeConflictResolver.getScopePriority(currentDep.getScope()) > DependencyTreeConflictResolver.getScopePriority(otherDep.getScope())) {
                    this.node.setScope(otherDep.getScope());
                }
                if (currentDep.isOptional() && !otherDep.isOptional()) {
                    this.node.setOptional(Boolean.valueOf(false));
                }
            }
            otherNode.setChildren(List.of());
            otherNode.setData((Object)"conflict.winner", (Object)new DefaultDependencyNode(this.node.getDependency()));
        }
    }
}

