/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class WrongAnnotationsProcessor {
    @BuildStep
    void detect(ArcConfig config, ApplicationIndexBuildItem applicationIndex, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationError) {
        if (!config.detectWrongAnnotations) {
            return;
        }
        Index index = applicationIndex.getIndex();
        ArrayList<WrongAnnotation> wrongAnnotations = new ArrayList<WrongAnnotation>();
        Function<AnnotationInstance, String> singletonFun = new Function<AnnotationInstance, String>(){

            @Override
            public String apply(AnnotationInstance annotationInstance) {
                return String.format("%s declared on %s, use @javax.inject.Singleton instead", annotationInstance.toString(false), WrongAnnotationsProcessor.getTargetInfo(annotationInstance));
            }
        };
        wrongAnnotations.add(new WrongAnnotation(DotName.createSimple((String)"com.google.inject.Singleton"), singletonFun));
        wrongAnnotations.add(new WrongAnnotation(DotName.createSimple((String)"javax.ejb.Singleton"), singletonFun));
        wrongAnnotations.add(new WrongAnnotation(DotName.createSimple((String)"groovy.lang.Singleton"), singletonFun));
        wrongAnnotations.add(new WrongAnnotation(DotName.createSimple((String)"jakarta.ejb.Singleton"), singletonFun));
        HashMap<AnnotationInstance, String> wrongUsages = new HashMap<AnnotationInstance, String>();
        for (WrongAnnotation wrongAnnotation : wrongAnnotations) {
            for (AnnotationInstance annotationInstance : index.getAnnotations(wrongAnnotation.name)) {
                wrongUsages.put(annotationInstance, wrongAnnotation.messageFun.apply(annotationInstance));
            }
        }
        if (!wrongUsages.isEmpty()) {
            for (Map.Entry entry : wrongUsages.entrySet()) {
                validationError.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException((String)entry.getValue())));
            }
        }
    }

    private static String getTargetInfo(AnnotationInstance annotationInstance) {
        AnnotationTarget target = annotationInstance.target();
        switch (target.kind()) {
            case FIELD: {
                return target.asField().declaringClass().toString() + "." + target.asField().name();
            }
            case METHOD: {
                return target.asMethod().declaringClass().toString() + "." + target.asMethod().name() + "()";
            }
        }
        return target.toString();
    }

    private static class WrongAnnotation {
        final DotName name;
        final Function<AnnotationInstance, String> messageFun;

        WrongAnnotation(DotName name, Function<AnnotationInstance, String> messageFun) {
            this.name = name;
            this.messageFun = messageFun;
        }
    }
}

