/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.ProjectInfo;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class QuarkusInfo
extends QuarkusPlatformTask {
    private boolean perModule = false;

    @Input
    public boolean getPerModule() {
        return this.perModule;
    }

    @Option(description="Log project's state per module.", option="perModule")
    public void setPerModule(boolean perModule) {
        this.perModule = perModule;
    }

    public QuarkusInfo() {
        super("Log Quarkus-specific project information, such as imported Quarkus platform BOMs, Quarkus extensions found among the project dependencies, etc.");
    }

    @TaskAction
    public void logInfo() {
        this.getLogger().warn(this.getName() + " is experimental, its options and output might change in future versions");
        QuarkusProject quarkusProject = this.getQuarkusProject(false);
        ProjectInfo invoker = new ProjectInfo(quarkusProject);
        invoker.perModule(this.perModule);
        invoker.appModel(this.extension().getApplicationModel());
        try {
            QuarkusCommandOutcome outcome = invoker.execute();
        }
        catch (Exception e) {
            throw new GradleException("Failed to collect Quarkus project information", (Throwable)e);
        }
    }
}

