/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.tasks.QuarkusPluginExtensionView;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tasks.worker.CodeGenWorker;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.gradle.workers.WorkQueue;

@CacheableTask
public abstract class QuarkusGenerateCode
extends QuarkusTask {
    public static final String QUARKUS_GENERATED_SOURCES = "quarkus-generated-sources";
    public static final String QUARKUS_TEST_GENERATED_SOURCES = "quarkus-test-generated-sources";
    public static final String[] CODE_GENERATION_PROVIDER = new String[]{"grpc", "avdl", "avpr", "avsc"};
    public static final String[] CODE_GENERATION_INPUT = new String[]{"proto", "avro"};
    private Set<Path> sourcesDirectories;
    private FileCollection compileClasspath;
    private final LaunchMode launchMode;
    private final String inputSourceSetName;
    private final QuarkusPluginExtensionView extensionView;

    @Inject
    public QuarkusGenerateCode(LaunchMode launchMode, String inputSourceSetName) {
        super("Performs Quarkus pre-build preparations, such as sources generation", true);
        this.launchMode = launchMode;
        this.inputSourceSetName = inputSourceSetName;
        this.extensionView = (QuarkusPluginExtensionView)this.getProject().getObjects().newInstance(QuarkusPluginExtensionView.class, new Object[]{this.extension()});
    }

    @Nested
    protected QuarkusPluginExtensionView getExtensionView() {
        return this.extensionView;
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.compileClasspath;
    }

    public void setCompileClasspath(Configuration compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    @Input
    Map<String, String> getInternalTaskConfig() {
        return Collections.unmodifiableMap(new TreeMap<String, String>(Map.of("launchMode", this.launchMode.name(), "inputSourceSetName", this.inputSourceSetName)));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Set<File> getInputDirectory() {
        HashSet<File> inputDirectories = new HashSet<File>();
        Path src = this.projectDir.toPath().resolve("src").resolve(this.inputSourceSetName);
        for (String input : CODE_GENERATION_INPUT) {
            Path providerSrcDir = src.resolve(input);
            if (!Files.exists(providerSrcDir, new LinkOption[0])) continue;
            inputDirectories.add(providerSrcDir.toFile());
        }
        return inputDirectories;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getApplicationModel();

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedOutputDirectory();

    @TaskAction
    public void generateCode() throws IOException {
        ApplicationModel appModel = ToolingUtils.deserializeAppModel((Path)((RegularFile)this.getApplicationModel().get()).getAsFile().toPath());
        Map<String, String> configMap = this.getExtensionView().buildEffectiveConfiguration(appModel, new HashMap()).getValues();
        File outputPath = ((Directory)this.getGeneratedOutputDirectory().get()).getAsFile();
        this.getLogger().debug("Will trigger preparing sources for source directories: {} buildDir: {}", this.sourcesDirectories, (Object)this.buildDir.getAbsolutePath());
        WorkQueue workQueue = this.workQueue(configMap, (List)this.getExtensionView().getCodeGenForkOptions().get());
        workQueue.submit(CodeGenWorker.class, params -> {
            params.getBuildSystemProperties().putAll(configMap);
            params.getBaseName().set(this.getExtensionView().getFinalName());
            params.getTargetDirectory().set(this.buildDir);
            params.getAppModel().set((Object)appModel);
            params.getSourceDirectories().setFrom((Iterable)this.sourcesDirectories.stream().map(Path::toFile).collect(Collectors.toList()));
            params.getOutputPath().set(outputPath);
            params.getLaunchMode().set((Object)this.launchMode);
            params.getGradleVersion().set((Object)GradleVersion.current().getVersion());
        });
        workQueue.await();
    }

    public void setSourcesDirectories(Set<Path> sourcesDirectories) {
        this.sourcesDirectories = sourcesDirectories;
    }
}

