/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.analytics.AnalyticsService;
import io.quarkus.analytics.config.FileLocationsImpl;
import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.DevModeCommandLine;
import io.quarkus.deployment.dev.DevModeCommandLineBuilder;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.ExtensionDevModeJvmOptionFilter;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.dsl.CompilerOption;
import io.quarkus.gradle.dsl.CompilerOptions;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.util.GradleVersion;

public abstract class QuarkusDev
extends QuarkusTask {
    public static final String IO_QUARKUS_DEVMODE_ARGS = "io.quarkus.devmode-args";
    private final Configuration quarkusDevConfiguration;
    private final SourceSet mainSourceSet;
    private final CompilerOptions compilerOptions = new CompilerOptions();
    private final ExtensionDevModeJvmOptionFilter extensionJvmOptions = new ExtensionDevModeJvmOptionFilter();
    private final Property<File> workingDirectory;
    private final MapProperty<String, String> environmentVariables;
    private final Property<Boolean> forceC2;
    private final Property<Boolean> shouldPropagateJavaCompilerArgs;
    private final ListProperty<String> args;
    private final ListProperty<String> jvmArgs;
    private final Property<Boolean> openJavaLang;
    private final ListProperty<String> modules;
    private final ListProperty<String> compilerArgs;
    private final Set<File> filesIncludedInClasspath = new HashSet<File>();

    @Inject
    public QuarkusDev(Configuration quarkusDevConfiguration, QuarkusPluginExtension extension) {
        this("Development mode: enables hot deployment with background compilation", quarkusDevConfiguration, extension);
    }

    public QuarkusDev(String name, Configuration quarkusDevConfiguration, QuarkusPluginExtension extension) {
        super(name);
        this.quarkusDevConfiguration = quarkusDevConfiguration;
        this.mainSourceSet = (SourceSet)((SourceSetContainer)this.getProject().getExtensions().getByType(SourceSetContainer.class)).getByName("main");
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.workingDirectory = objectFactory.property(File.class);
        this.workingDirectory.convention(this.getProject().provider(() -> QuarkusPluginExtension.getLastFile(this.getCompilationOutput())));
        this.environmentVariables = objectFactory.mapProperty(String.class, String.class);
        this.forceC2 = objectFactory.property(Boolean.class);
        this.shouldPropagateJavaCompilerArgs = objectFactory.property(Boolean.class);
        this.shouldPropagateJavaCompilerArgs.convention((Object)true);
        this.args = objectFactory.listProperty(String.class);
        this.compilerArgs = objectFactory.listProperty(String.class);
        this.jvmArgs = objectFactory.listProperty(String.class);
        this.openJavaLang = objectFactory.property(Boolean.class);
        this.openJavaLang.convention((Object)false);
        this.modules = objectFactory.listProperty(String.class);
    }

    @CompileClasspath
    public Configuration getQuarkusDevConfiguration() {
        return this.quarkusDevConfiguration;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSources() {
        return this.mainSourceSet.getAllJava().getSourceDirectories();
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCompilationOutput() {
        return this.mainSourceSet.getOutput().getClassesDirs();
    }

    @Input
    public Property<File> getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Deprecated
    public void setWorkingDir(String workingDir) {
        this.workingDirectory.set((Object)this.getProject().file((Object)workingDir));
    }

    @Input
    public MapProperty<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Internal
    public Map<String, String> getEnvVars() {
        return (Map)this.environmentVariables.get();
    }

    @Input
    @Optional
    public Property<Boolean> getForceC2() {
        return this.forceC2;
    }

    @Input
    public ListProperty<String> getJvmArguments() {
        return this.jvmArgs;
    }

    @Internal
    public List<String> getJvmArgs() {
        return (List)this.jvmArgs.get();
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs.set(jvmArgs);
    }

    @Input
    public ListProperty<String> getArguments() {
        return this.args;
    }

    @Option(description="Modules to add to the application", option="modules")
    public void setModules(List<String> modules) {
        this.modules.set(modules);
    }

    @Input
    public ListProperty<String> getModules() {
        return this.modules;
    }

    @Option(description="Open Java Lang module", option="open-lang-package")
    public void setOpenJavaLang(Boolean openJavaLang) {
        this.openJavaLang.set((Object)openJavaLang);
    }

    @Input
    public Property<Boolean> getOpenJavaLang() {
        return this.openJavaLang;
    }

    @Internal
    public List<String> getArgs() {
        return (List)this.args.get();
    }

    public void setArgs(List<String> args) {
        this.args.set(args);
    }

    @Option(description="Set application arguments", option="quarkus-args")
    public void setArgsString(String argsString) {
        this.setArgs(Arrays.asList(Commandline.translateCommandline((String)argsString)));
    }

    @Input
    public ListProperty<String> getCompilerArguments() {
        return this.compilerArgs;
    }

    @Internal
    public List<String> getCompilerArgs() {
        return (List)this.getCompilerArguments().get();
    }

    @Option(description="Additional parameters to pass to javac when recompiling changed source files", option="compiler-args")
    public void setCompilerArgs(List<String> compilerArgs) {
        this.getCompilerArguments().set(compilerArgs);
    }

    @Internal
    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public QuarkusDev compilerOptions(Action<CompilerOptions> action) {
        action.execute((Object)this.compilerOptions);
        return this;
    }

    @Internal
    public ExtensionDevModeJvmOptionFilter getExtensionJvmOptions() {
        return this.extensionJvmOptions;
    }

    public QuarkusDev extensionJvmOptions(Action<ExtensionDevModeJvmOptionFilter> action) {
        action.execute((Object)this.extensionJvmOptions);
        return this;
    }

    @TaskAction
    public void startDev() {
        block15: {
            if (!this.sourcesExist()) {
                throw new GradleException("At least one source directory (e.g. src/main/java, src/main/kotlin) should contain sources before starting Quarkus in dev mode when using Gradle. Please initialize your project a bit further before restarting Quarkus in dev mode.");
            }
            if (!this.classesExist()) {
                throw new GradleException("The project has no output yet, this should not happen as build should have been executed first. Does the project have any source files?");
            }
            analyticsService.buildAnalyticsUserInput(prompt -> {
                System.out.print((String)prompt);
                Scanner scanner = new Scanner(new FilterInputStream(System.in){

                    @Override
                    public void close() throws IOException {
                    }
                });
                try {
                    String string = scanner.nextLine();
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.getLogger().debug("Failed to collect user input for analytics", (Throwable)e);
                        return "";
                    }
                }
            });
            try (AnalyticsService analyticsService = new AnalyticsService(FileLocationsImpl.INSTANCE, (MessageWriter)new GradleMessageWriter(this.getLogger()));){
                DevModeCommandLine runner = this.newLauncher(analyticsService);
                String outputFile = System.getProperty(IO_QUARKUS_DEVMODE_ARGS);
                if (outputFile == null) {
                    this.getProject().exec(action -> {
                        action.commandLine((Iterable)runner.getArguments()).workingDir(this.getWorkingDirectory().get());
                        action.environment(this.getEnvVars());
                        action.setStandardInput(System.in).setErrorOutput((OutputStream)System.out).setStandardOutput((OutputStream)System.out);
                    });
                    break block15;
                }
                try (BufferedWriter is = Files.newBufferedWriter(Paths.get(outputFile, new String[0]), new OpenOption[0]);){
                    for (String i : runner.getArguments()) {
                        is.write(i);
                        is.newLine();
                    }
                }
            }
        }
    }

    private boolean sourcesExist() {
        Set srcDirLocations = (Set)this.mainSourceSet.getAllJava().getSourceDirectories().getElements().get();
        for (FileSystemLocation srcDirLocation : srcDirLocations) {
            File[] files;
            File srcDir = srcDirLocation.getAsFile();
            if (!srcDir.exists() || !srcDir.isDirectory() || (files = srcDir.listFiles()) == null || files.length <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean classesExist() {
        for (FileSystemLocation location : (Set)this.getCompilationOutput().getElements().get()) {
            File locationAsFile = location.getAsFile();
            if (!locationAsFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private DevModeCommandLine newLauncher(AnalyticsService analyticsService) throws Exception {
        Object toolchainSpec;
        JavaToolchainService toolChainService;
        Provider provider;
        Project project = this.getProject();
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        String java = null;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.7")) >= 0 && (provider = (toolChainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class)).launcherFor((JavaToolchainSpec)(toolchainSpec = javaPluginExtension.getToolchain()))).isPresent()) {
            java = ((JavaLauncher)provider.get()).getExecutablePath().getAsFile().getAbsolutePath();
        }
        DevModeCommandLineBuilder builder = DevModeCommandLine.builder(java).forceC2((Boolean)this.getForceC2().getOrNull()).projectDir(this.projectDir).buildDir(this.buildDir).outputDir(this.buildDir).debug(System.getProperty("debug")).debugHost(System.getProperty("debugHost")).debugPort(System.getProperty("debugPort")).suspend(System.getProperty("suspend"));
        if (System.getProperty(IO_QUARKUS_DEVMODE_ARGS) == null) {
            builder.jvmArgs("-Dquarkus.console.basic=true").jvmArgs("-Dio.quarkus.force-color-support=true");
        }
        if (this.getJvmArguments().isPresent() && !((List)this.getJvmArguments().get()).isEmpty()) {
            builder.jvmArgs(this.getJvmArgs());
        }
        if (this.getOpenJavaLang().isPresent() && ((Boolean)this.getOpenJavaLang().get()).booleanValue()) {
            builder.addOpens("java.base/java.lang=ALL-UNNAMED");
        }
        if (this.getModules().isPresent() && !((List)this.getModules().get()).isEmpty()) {
            builder.addModules((Collection)this.getModules().get());
        }
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            builder.buildSystemProperty((String)entry.getKey(), entry.getValue().toString());
        }
        builder.applicationName(project.getName());
        builder.applicationVersion(project.getVersion().toString());
        builder.sourceEncoding(this.getSourceEncoding());
        ApplicationModel appModel = this.extension().getApplicationModel(LaunchMode.DEVELOPMENT);
        builder.extensionDevModeConfig(appModel.getExtensionDevModeConfig()).extensionDevModeJvmOptionFilter(this.extensionJvmOptions);
        analyticsService.sendAnalytics(TrackEventType.DEV_MODE, appModel, Map.of("gradle.version", this.getProject().getGradle().getGradleVersion()), this.getProject().getBuildDir().getAbsoluteFile());
        HashSet<ArtifactKey> hashSet = new HashSet<ArtifactKey>();
        for (Object localDep : DependenciesFilter.getReloadableModules((ApplicationModel)appModel)) {
            this.addLocalProject((ResolvedDependency)localDep, builder, hashSet, appModel.getAppArtifact().getWorkspaceModule().getId().equals(localDep.getWorkspaceModule().getId()));
        }
        this.addQuarkusDevModeDeps(builder, appModel);
        HashSet<Path> resourceDirs = new HashSet<Path>();
        for (Object resourceDir : appModel.getApplicationModule().getMainSources().getResourceDirs()) {
            resourceDirs.add(resourceDir.getOutputDir());
        }
        Collection configuredParentFirst = ConfiguredClassLoading.builder().setApplicationModel(appModel).setApplicationRoot((PathCollection)PathsCollection.from(resourceDirs)).setMode(QuarkusBootstrap.Mode.DEV).build().getParentFirstArtifacts();
        for (ResolvedDependency artifact : appModel.getDependencies()) {
            if (hashSet.contains(artifact.getKey())) continue;
            artifact.getResolvedPaths().forEach(p -> {
                File file = p.toFile();
                if (file.exists() && configuredParentFirst.contains(artifact.getKey()) && this.filesIncludedInClasspath.add(file)) {
                    this.getLogger().debug("Adding dependency {}", (Object)file);
                    builder.classpathEntry(artifact.getKey(), file);
                }
            });
        }
        builder.sourceJavaVersion(javaPluginExtension.getSourceCompatibility().toString());
        builder.targetJavaVersion(javaPluginExtension.getTargetCompatibility().toString());
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        builder.annotationProcessorPaths(mainSourceSet.getAnnotationProcessorPath().getFiles());
        for (CompilerOption compilerOptions : this.compilerOptions.getCompilerOptions()) {
            builder.compilerOptions(compilerOptions.getName(), compilerOptions.getArgs());
        }
        if (((Boolean)this.shouldPropagateJavaCompilerArgs.get()).booleanValue() && this.getCompilerArgs().isEmpty()) {
            this.getJavaCompileTask().map(compileTask -> compileTask.getOptions().getCompilerArgs()).ifPresent(args -> builder.compilerOptions("java", args));
        } else {
            builder.compilerOptions("java", this.getCompilerArgs());
        }
        this.modifyDevModeContext(builder);
        Path serializedModel = ToolingUtils.serializeAppModel((ApplicationModel)appModel, (Task)this, (boolean)false);
        serializedModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal.serialized-app-model.path=" + serializedModel.toAbsolutePath());
        ApplicationModel testAppModel = this.extension().getApplicationModel(LaunchMode.TEST);
        Path serializedTestModel = ToolingUtils.serializeAppModel((ApplicationModel)testAppModel, (Task)this, (boolean)true);
        serializedTestModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal-test.serialized-app-model.path=" + serializedTestModel.toAbsolutePath());
        if (this.args.isPresent() && !((List)this.args.get()).isEmpty()) {
            builder.applicationArgs(String.join((CharSequence)" ", (Iterable)this.args.get()));
        }
        return builder.build();
    }

    protected void modifyDevModeContext(DevModeCommandLineBuilder builder) {
    }

    private void addQuarkusDevModeDeps(DevModeCommandLineBuilder builder, ApplicationModel appModel) {
        Configuration devModeDependencyConfiguration = (Configuration)this.getProject().getConfigurations().findByName("quarkusBootstrapResolverConfiguration");
        if (devModeDependencyConfiguration == null) {
            Configuration platformConfig = (Configuration)this.getProject().getConfigurations().findByName(ToolingUtils.toPlatformConfigurationName((String)ApplicationDeploymentClasspathBuilder.getFinalRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
            this.getProject().getConfigurations().register("quarkusBootstrapResolverConfiguration", configuration -> {
                configuration.setCanBeConsumed(false);
                configuration.extendsFrom(new Configuration[]{platformConfig});
                configuration.getDependencies().add((Object)this.getQuarkusGradleBootstrapResolver());
                configuration.getDependencies().add((Object)this.getQuarkusCoreDeployment(appModel));
            });
            devModeDependencyConfiguration = this.getProject().getConfigurations().getByName("quarkusBootstrapResolverConfiguration");
        }
        for (ResolvedArtifact appDep : devModeDependencyConfiguration.getResolvedConfiguration().getResolvedArtifacts()) {
            ModuleVersionIdentifier artifactId = appDep.getModuleVersion().getId();
            if (artifactId.getGroup().equals("io.quarkus") && artifactId.getName().equals("quarkus-ide-launcher")) continue;
            if (artifactId.getGroup().equals("io.quarkus") && artifactId.getName().equals("quarkus-class-change-agent")) {
                builder.jvmArgs("-javaagent:" + appDep.getFile().getAbsolutePath());
                continue;
            }
            builder.classpathEntry(ArtifactKey.of((String)appDep.getModuleVersion().getId().getGroup(), (String)appDep.getName(), (String)appDep.getClassifier(), (String)appDep.getExtension()), appDep.getFile());
        }
    }

    private Dependency getQuarkusGradleBootstrapResolver() {
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties";
        InputStream devModePomPropsIs = DevModeMain.class.getClassLoader().getResourceAsStream("META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties");
        if (devModePomPropsIs == null) {
            throw new GradleException("Failed to locate META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties on the classpath");
        }
        Properties devModeProps = new Properties();
        try (InputStream is = devModePomPropsIs;){
            devModeProps.load(is);
        }
        catch (IOException e) {
            throw new GradleException("Failed to load META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties from the classpath", (Throwable)e);
        }
        String devModeGroupId = devModeProps.getProperty("groupId");
        if (devModeGroupId == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties is missing groupId");
        }
        String devModeArtifactId = devModeProps.getProperty("artifactId");
        if (devModeArtifactId == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties is missing artifactId");
        }
        String devModeVersion = devModeProps.getProperty("version");
        if (devModeVersion == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties is missing version");
        }
        Dependency gradleResolverDep = this.getProject().getDependencies().create((Object)String.format("%s:%s:%s", devModeGroupId, devModeArtifactId, devModeVersion));
        return gradleResolverDep;
    }

    private Dependency getQuarkusCoreDeployment(ApplicationModel appModel) {
        ResolvedDependency coreDeployment = null;
        for (ResolvedDependency d : appModel.getDependencies()) {
            if (!d.isDeploymentCp() || !d.getArtifactId().equals("quarkus-core-deployment") || !d.getGroupId().equals("io.quarkus")) continue;
            coreDeployment = d;
            break;
        }
        if (coreDeployment == null) {
            throw new GradleException("Failed to locate io.quarkus:quarkus-core-deployment on the application build classpath");
        }
        return this.getProject().getDependencies().create((Object)String.format("%s:%s:%s", coreDeployment.getGroupId(), coreDeployment.getArtifactId(), coreDeployment.getVersion()));
    }

    private void addLocalProject(ResolvedDependency project, DevModeCommandLineBuilder builder, Set<ArtifactKey> addeDeps, boolean root) {
        String resourcesOutputPath;
        addeDeps.add(project.getKey());
        ArtifactSources sources = project.getSources();
        if (sources == null) {
            return;
        }
        LinkedHashSet<Path> sourcePaths = new LinkedHashSet<Path>();
        LinkedHashSet<Path> sourceParentPaths = new LinkedHashSet<Path>();
        HashSet<Path> classesDirs = new HashSet<Path>(sources.getSourceDirs().size());
        for (SourceDir src : sources.getSourceDirs()) {
            if (!Files.exists(src.getDir(), new LinkOption[0])) continue;
            sourcePaths.add(src.getDir());
            sourceParentPaths.add(src.getDir().getParent());
            if (src.getOutputDir() == null) continue;
            classesDirs.add(src.getOutputDir());
        }
        Path classesDir = classesDirs.isEmpty() ? null : QuarkusGradleUtils.mergeClassesDirs(classesDirs, project.getWorkspaceModule().getBuildDir(), true, false);
        Path generatedSourcesPath = sources.getSourceDirs().isEmpty() ? null : ((SourceDir)sources.getSourceDirs().iterator().next()).getAptSourcesDir();
        LinkedHashSet<Path> resourcesSrcDirs = new LinkedHashSet<Path>();
        Path resourcesOutputDir = null;
        for (SourceDir resource : sources.getResourceDirs()) {
            resourcesSrcDirs.add(resource.getDir());
            if (resourcesOutputDir != null) continue;
            resourcesOutputDir = resource.getOutputDir();
        }
        if (sourcePaths.isEmpty() && (resourcesOutputDir == null || !Files.exists(resourcesOutputDir, new LinkOption[0])) || classesDir == null) {
            return;
        }
        if (resourcesOutputDir != null && Files.exists(resourcesOutputDir, new LinkOption[0])) {
            resourcesOutputPath = resourcesOutputDir.toString();
            if (!Files.exists(classesDir, new LinkOption[0])) {
                classesDir = resourcesOutputDir;
            }
        } else {
            resourcesOutputPath = classesDir.toString();
        }
        DevModeContext.ModuleInfo.Builder moduleBuilder = new DevModeContext.ModuleInfo.Builder().setArtifactKey(project.getKey()).setName(project.getArtifactId()).setProjectDirectory(project.getWorkspaceModule().getModuleDir().getAbsolutePath()).setSourcePaths((PathCollection)PathList.from(sourcePaths)).setGeneratedSourcesPath(generatedSourcesPath != null ? generatedSourcesPath.toString() : null).setClassesPath(classesDir.toString()).setResourcePaths((PathCollection)PathList.from(resourcesSrcDirs)).setResourcesOutputPath(resourcesOutputPath).setSourceParents((PathCollection)PathList.from(sourceParentPaths)).setPreBuildOutputDir(project.getWorkspaceModule().getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(project.getWorkspaceModule().getBuildDir().toString());
        ArtifactSources testSources = project.getWorkspaceModule().getTestSources();
        if (testSources != null) {
            LinkedHashSet<Path> testSourcePaths = new LinkedHashSet<Path>();
            HashSet<Path> testClassesDirs = new HashSet<Path>(testSources.getSourceDirs().size());
            for (SourceDir src : testSources.getSourceDirs()) {
                if (!Files.exists(src.getDir(), new LinkOption[0])) continue;
                testSourcePaths.add(src.getDir());
                if (src.getOutputDir() == null) continue;
                testClassesDirs.add(src.getOutputDir());
            }
            Path testClassesDir = testClassesDirs.isEmpty() ? null : QuarkusGradleUtils.mergeClassesDirs(testClassesDirs, project.getWorkspaceModule().getBuildDir(), root, root);
            LinkedHashSet<Path> testResourcesSrcDirs = new LinkedHashSet<Path>();
            Path testResourcesOutputDir = null;
            for (SourceDir resource : testSources.getResourceDirs()) {
                testResourcesSrcDirs.add(resource.getDir());
                if (testResourcesOutputDir != null) continue;
                testResourcesOutputDir = resource.getOutputDir();
            }
            if (testClassesDir != null && (!testSourcePaths.isEmpty() || testResourcesOutputDir != null && Files.exists(testResourcesOutputDir, new LinkOption[0]))) {
                String testResourcesOutputPath;
                if (testResourcesOutputDir != null && Files.exists(testResourcesOutputDir, new LinkOption[0])) {
                    testResourcesOutputPath = testResourcesOutputDir.toString();
                    if (!Files.exists(testClassesDir, new LinkOption[0])) {
                        testClassesDir = testResourcesOutputDir;
                    }
                } else {
                    testResourcesOutputPath = testClassesDir.toString();
                }
                moduleBuilder.setTestSourcePaths((PathCollection)PathList.from(testSourcePaths)).setTestClassesPath(testClassesDir.toString()).setTestResourcePaths((PathCollection)PathList.from(testResourcesSrcDirs)).setTestResourcesOutputPath(testResourcesOutputPath);
            }
        }
        DevModeContext.ModuleInfo wsModuleInfo = moduleBuilder.build();
        if (root) {
            builder.mainModule(wsModuleInfo);
        } else {
            builder.dependency(wsModuleInfo);
        }
    }

    private String getSourceEncoding() {
        return this.getJavaCompileTask().map(javaCompile -> javaCompile.getOptions().getEncoding()).orElse(null);
    }

    private java.util.Optional<JavaCompile> getJavaCompileTask() {
        return java.util.Optional.ofNullable((JavaCompile)this.getProject().getTasks().getByName("compileJava"));
    }

    public void shouldPropagateJavaCompilerArgs(boolean shouldPropagateJavaCompilerArgs) {
        this.shouldPropagateJavaCompilerArgs.set((Object)shouldPropagateJavaCompilerArgs);
    }
}

