/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.gradle.api.logging.Logger;

public class ProcessUtil {
    public static final int LOG_CHECK_INTERVAL = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(List<String> args, File wdir, Logger logger) {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]).command(args).redirectInput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).directory(wdir);
            final Process process = builder.start();
            ProcessReader error = new ProcessReader(process.getErrorStream());
            ProcessReader stdout = new ProcessReader(process.getInputStream());
            Thread t = new Thread((Runnable)error, "Error stream reader");
            t.start();
            t = new Thread((Runnable)stdout, "Stdout stream reader");
            t.start();
            Runtime.getRuntime().addShutdownHook(new Thread("Quarkus Run Process Shutdown"){

                @Override
                public void run() {
                    ProcessUtil.destroyProcess(process, true);
                }
            });
            try {
                process.waitFor();
            }
            finally {
                ProcessUtil.destroyProcess(process, true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void destroyProcess(Process quarkusProcess) {
        quarkusProcess.destroy();
        int i = 0;
        while (i++ < 10) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (quarkusProcess.isAlive()) continue;
        }
        if (quarkusProcess.isAlive()) {
            quarkusProcess.destroyForcibly();
        }
    }

    public static void destroyProcess(ProcessHandle quarkusProcess) {
        try {
            CompletableFuture<ProcessHandle> exit = quarkusProcess.onExit();
            if (!quarkusProcess.destroy()) {
                quarkusProcess.destroyForcibly();
                return;
            }
            exit.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (quarkusProcess.isAlive()) {
            quarkusProcess.destroyForcibly();
        }
    }

    public static void destroyProcess(Process process, boolean children) {
        if (!children) {
            ProcessUtil.destroyProcess(process);
            return;
        }
        process.descendants().forEach(p -> ProcessUtil.destroyProcess(p));
        ProcessUtil.destroyProcess(process);
    }

    private static class ProcessReader
    implements Runnable {
        private final InputStream inputStream;

        private ProcessReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            byte[] b = new byte[100];
            try {
                int i;
                while ((i = this.inputStream.read(b)) > 0) {
                    System.out.print(new String(b, 0, i, StandardCharsets.UTF_8));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

