/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.gradle.ModelParameter;
import io.quarkus.bootstrap.model.gradle.impl.ModelParameterImpl;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;

public class AppModelGradleResolver
implements AppModelResolver {
    private final Project project;
    private final LaunchMode mode;

    public AppModelGradleResolver(Project project, LaunchMode mode) {
        this.project = project;
        this.mode = mode;
    }

    public String getLatestVersion(ArtifactCoords appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        try {
            return this.resolveArtifact((ArtifactCoords)new GACTV(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), "[" + appArtifact.getVersion() + "," + upToVersion + (inclusive ? "]" : ")"))).getVersion();
        }
        catch (AppModelResolverException e) {
            return null;
        }
    }

    public String getLatestVersionFromRange(ArtifactCoords appArtifact, String range) throws AppModelResolverException {
        try {
            return this.resolveArtifact((ArtifactCoords)new GACTV(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), range)).getVersion();
        }
        catch (AppModelResolverException e) {
            return null;
        }
    }

    public String getNextVersion(ArtifactCoords appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionIncluded) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public List<String> listLaterVersions(ArtifactCoords appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public void relink(ArtifactCoords artifact, Path localPath) throws AppModelResolverException {
    }

    public ResolvedDependency resolve(ArtifactCoords appArtifact) throws AppModelResolverException {
        return this.resolveArtifact(appArtifact);
    }

    private ResolvedDependency resolveArtifact(ArtifactCoords appArtifact) throws AppModelResolverException {
        Set resolvedArtifacts;
        ResolvedDependency resolved;
        if (ResolvedDependency.class.isAssignableFrom(appArtifact.getClass()) && (resolved = (ResolvedDependency)appArtifact).isResolved()) {
            return resolved;
        }
        DefaultDependencyArtifact dep = new DefaultDependencyArtifact();
        dep.setExtension(appArtifact.getType());
        dep.setType(appArtifact.getType());
        dep.setName(appArtifact.getArtifactId());
        if (appArtifact.getClassifier() != null) {
            dep.setClassifier(appArtifact.getClassifier());
        }
        DefaultExternalModuleDependency gradleDep = new DefaultExternalModuleDependency(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion(), null);
        gradleDep.addArtifact((DependencyArtifact)dep);
        Configuration detachedConfig = this.project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep});
        ResolvedConfiguration rc = detachedConfig.getResolvedConfiguration();
        try {
            resolvedArtifacts = rc.getResolvedArtifacts();
        }
        catch (ResolveException e) {
            throw new AppModelResolverException("Failed to resolve " + appArtifact, (Throwable)e);
        }
        for (ResolvedArtifact a : resolvedArtifacts) {
            if (!appArtifact.getArtifactId().equals(a.getName()) || !appArtifact.getType().equals(a.getType()) || !(a.getClassifier() == null ? appArtifact.getClassifier() == null : a.getClassifier().equals(appArtifact.getClassifier())) || !appArtifact.getGroupId().equals(a.getModuleVersion().getId().getGroup())) continue;
            String version = appArtifact.getVersion().equals(a.getModuleVersion().getId().getVersion()) ? appArtifact.getVersion() : a.getModuleVersion().getId().getVersion();
            return new ResolvedArtifactDependency(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), version, a.getFile().toPath());
        }
        throw new AppModelResolverException("Failed to resolve " + appArtifact);
    }

    public Collection<ResolvedDependency> resolveUserDependencies(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> directDeps) {
        return Collections.emptyList();
    }

    public ApplicationModel resolveModel(ArtifactCoords appArtifact) throws AppModelResolverException {
        this.ensureProjectCoords(appArtifact);
        return ToolingUtils.create((Project)this.project, (LaunchMode)this.mode);
    }

    public ApplicationModel resolveModel(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> deps) throws AppModelResolverException {
        this.ensureProjectCoords(appArtifact);
        ModelParameterImpl param = new ModelParameterImpl();
        param.setMode(this.mode.toString());
        return ToolingUtils.create((Project)this.project, (ModelParameter)param);
    }

    public ApplicationModel resolveManagedModel(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> directDeps, ArtifactCoords managingProject, Set<ArtifactKey> localProjects) throws AppModelResolverException {
        return this.resolveModel(appArtifact);
    }

    protected void ensureProjectCoords(ArtifactCoords appArtifact) throws AppModelResolverException {
        if (this.project.getName().equals(appArtifact.getArtifactId()) && this.project.getGroup().toString().equals(appArtifact.getGroupId()) && this.project.getVersion().toString().equals(appArtifact.getVersion())) {
            return;
        }
        throw new AppModelResolverException("Requested artifact " + appArtifact + " does not match project " + this.project.getGroup() + ":" + this.project.getName() + ":" + this.project.getVersion());
    }
}

