/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.extension;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.gradle.AppModelGradleResolver;
import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.extension.SourceSetExtension;
import io.quarkus.gradle.tasks.AbstractQuarkusExtension;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;
import org.gradle.process.JavaForkOptions;

public abstract class QuarkusPluginExtension
extends AbstractQuarkusExtension {
    private final SourceSetExtension sourceSetExtension;
    private final Property<Boolean> cacheLargeArtifacts;
    private final Property<Boolean> cleanupBuildOutput;

    public QuarkusPluginExtension(Project project) {
        super(project);
        this.cleanupBuildOutput = project.getObjects().property(Boolean.class).convention((Object)true);
        this.cacheLargeArtifacts = project.getObjects().property(Boolean.class).convention((Object)(!System.getenv().containsKey("CI") ? 1 : 0));
        this.sourceSetExtension = new SourceSetExtension();
    }

    public Manifest getManifest() {
        return this.manifest();
    }

    public void manifest(Action<Manifest> action) {
        action.execute((Object)this.getManifest());
    }

    public void beforeTest(Test task) {
        try {
            Map props = task.getSystemProperties();
            ApplicationModel appModel = this.getApplicationModel(LaunchMode.TEST);
            SmallRyeConfig config = this.buildEffectiveConfiguration(appModel.getAppArtifact()).getConfig();
            config.getOptionalValue(LaunchMode.TEST.getProfileKey(), String.class).ifPresent(value -> props.put(LaunchMode.TEST.getProfileKey(), value));
            Path serializedModel = ToolingUtils.serializeAppModel((ApplicationModel)appModel, (Task)task, (boolean)true);
            props.put("quarkus-internal-test.serialized-app-model.path", serializedModel.toString());
            StringJoiner outputSourcesDir = new StringJoiner(",");
            for (File outputSourceDir : this.combinedOutputSourceDirs()) {
                outputSourcesDir.add(outputSourceDir.getAbsolutePath());
            }
            props.put("OUTPUT_SOURCES_DIR", outputSourcesDir.toString());
            SourceSetContainer sourceSets = this.getSourceSets();
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            File outputDirectoryAsFile = QuarkusPluginExtension.getLastFile(mainSourceSet.getOutput().getClassesDirs());
            Path projectDirPath = this.projectDir.toPath();
            String fileList = sourceSets.stream().filter(sourceSet -> Objects.equals(task.getTestClassesDirs().getAsPath(), sourceSet.getOutput().getClassesDirs().getAsPath())).flatMap(sourceSet -> sourceSet.getOutput().getClassesDirs().getFiles().stream()).filter(File::exists).distinct().map(testSrcDir -> String.format("%s:%s", projectDirPath.relativize(testSrcDir.toPath()), projectDirPath.relativize(outputDirectoryAsFile.toPath()))).collect(Collectors.joining(","));
            task.environment("TEST_TO_MAIN_MAPPINGS", (Object)fileList);
            task.getLogger().debug("test dir mapping - {}", (Object)fileList);
            QuarkusBuild quarkusBuild = (QuarkusBuild)((Object)this.project.getTasks().named("quarkusBuild", QuarkusBuild.class).get());
            String nativeRunner = quarkusBuild.getNativeRunner().toPath().toAbsolutePath().toString();
            props.put("native.image.path", nativeRunner);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve deployment classpath", e);
        }
    }

    public Property<String> getFinalName() {
        return this.finalName;
    }

    public Property<Boolean> getCleanupBuildOutput() {
        return this.cleanupBuildOutput;
    }

    public void setCleanupBuildOutput(boolean cleanupBuildOutput) {
        this.cleanupBuildOutput.set((Object)cleanupBuildOutput);
    }

    public Property<Boolean> getCacheLargeArtifacts() {
        return this.cacheLargeArtifacts;
    }

    public void setCacheLargeArtifacts(boolean cacheLargeArtifacts) {
        this.cacheLargeArtifacts.set((Object)cacheLargeArtifacts);
    }

    public String finalName() {
        return (String)this.getFinalName().get();
    }

    public void setFinalName(String finalName) {
        this.getFinalName().set((Object)finalName);
    }

    public void sourceSets(Action<? super SourceSetExtension> action) {
        action.execute((Object)this.sourceSetExtension);
    }

    public SourceSetExtension sourceSetExtension() {
        return this.sourceSetExtension;
    }

    public Set<File> resourcesDir() {
        return ((SourceSet)this.getSourceSets().getByName("main")).getResources().getSrcDirs();
    }

    public static FileCollection combinedOutputSourceDirs(Project project) {
        ConfigurableFileCollection classesDirs = project.files(new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        classesDirs.from(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput().getClassesDirs()});
        classesDirs.from(new Object[]{((SourceSet)sourceSets.getByName("test")).getOutput().getClassesDirs()});
        return classesDirs;
    }

    public Set<File> combinedOutputSourceDirs() {
        LinkedHashSet<File> sourcesDirs = new LinkedHashSet<File>();
        SourceSetContainer sourceSets = this.getSourceSets();
        sourcesDirs.addAll(((SourceSet)sourceSets.getByName("main")).getOutput().getClassesDirs().getFiles());
        sourcesDirs.addAll(((SourceSet)sourceSets.getByName("test")).getOutput().getClassesDirs().getFiles());
        return sourcesDirs;
    }

    public AppModelResolver getAppModelResolver() {
        return this.getAppModelResolver(LaunchMode.NORMAL);
    }

    public AppModelResolver getAppModelResolver(LaunchMode mode) {
        return new AppModelGradleResolver(this.project, mode);
    }

    public ApplicationModel getApplicationModel() {
        return this.getApplicationModel(LaunchMode.NORMAL);
    }

    public ApplicationModel getApplicationModel(LaunchMode mode) {
        return ToolingUtils.create((Project)this.project, (LaunchMode)mode);
    }

    public void buildForkOptions(Action<? super JavaForkOptions> action) {
        this.buildForkOptions.add(action);
    }

    public void codeGenForkOptions(Action<? super JavaForkOptions> action) {
        this.codeGenForkOptions.add(action);
    }

    public static File getLastFile(FileCollection fileCollection) {
        File result = null;
        for (File f : fileCollection) {
            if (result != null && !f.exists()) continue;
            result = f;
        }
        return result;
    }

    private SourceSetContainer getSourceSets() {
        return (SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class);
    }

    public Path appJarOrClasses() {
        SourceSet mainSourceSet;
        String classesPath;
        File f;
        Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
        if (jarTask == null) {
            throw new RuntimeException("Failed to locate task 'jar' in the project.");
        }
        Provider jarProvider = jarTask.getArchiveFile();
        Path classesDir = null;
        if (jarProvider.isPresent() && (f = ((RegularFile)jarProvider.get()).getAsFile()).exists()) {
            classesDir = f.toPath();
        }
        if (classesDir == null && (classesPath = QuarkusGradleUtils.getClassesDir(mainSourceSet = (SourceSet)this.getSourceSets().getByName("main"), jarTask.getTemporaryDir(), false)) != null) {
            classesDir = Paths.get(classesPath, new String[0]);
        }
        if (classesDir == null) {
            throw new RuntimeException("Failed to locate project's classes directory");
        }
        return classesDir;
    }

    public MapProperty<String, String> getQuarkusBuildProperties() {
        return this.quarkusBuildProperties;
    }

    public ListProperty<String> getCachingRelevantProperties() {
        return this.cachingRelevantProperties;
    }

    public void set(String name, @Nullable String value) {
        this.quarkusBuildProperties.put((Object)this.addQuarkusBuildPropertyPrefix(name), (Object)value);
    }

    public void set(String name, Provider<String> value) {
        this.quarkusBuildProperties.put((Object)this.addQuarkusBuildPropertyPrefix(name), value);
    }

    private String addQuarkusBuildPropertyPrefix(String name) {
        return String.format("quarkus.%s", name);
    }
}

