/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import com.google.common.base.Preconditions;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultSourceDir;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.workspace.descriptors.DefaultProjectDescriptor;
import io.quarkus.gradle.workspace.descriptors.ProjectDescriptor;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.GAV;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class QuarkusApplicationModelTask
extends DefaultTask {
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;
    public static final String QUARKUS_PROJECT_DESCRIPTOR_ARTIFACT_TYPE = "quarkus-project-descriptor";

    @Internal
    public abstract RegularFileProperty getProjectBuildFile();

    @Inject
    public abstract ProjectLayout getLayout();

    @CompileClasspath
    public abstract ConfigurableFileCollection getOriginalClasspath();

    @InputFiles
    public abstract ConfigurableFileCollection getDeploymentResolvedWorkaround();

    @Nested
    public abstract QuarkusResolvedClasspath getPlatformConfiguration();

    @Nested
    public abstract QuarkusResolvedClasspath getAppClasspath();

    @Nested
    public abstract QuarkusResolvedClasspath getDeploymentClasspath();

    @Input
    public abstract Property<LaunchMode> getLaunchMode();

    @Input
    public abstract MapProperty<String, String> getPlatformImportProperties();

    @Input
    public abstract Property<DefaultProjectDescriptor> getProjectDescriptor();

    @OutputFile
    public abstract RegularFileProperty getApplicationModel();

    public QuarkusApplicationModelTask() {
        this.getProjectBuildFile().set(this.getProject().getBuildFile());
    }

    private void collectPlatforms(ResolvedDependencyResult resolvedDependency, Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifactsByCapability, PlatformImportsImpl platformImports) {
        List<QuarkusResolvedArtifact> artifacts = QuarkusApplicationModelTask.findArtifacts(resolvedDependency, artifactsByCapability);
        ModuleVersionIdentifier moduleVersionIdentifier = resolvedDependency.getSelected().getModuleVersion();
        for (QuarkusResolvedArtifact artifact : artifacts) {
            if (artifact != null && artifact.file.getName().endsWith(".properties")) {
                try {
                    platformImports.addPlatformProperties(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), null, "properties", moduleVersionIdentifier.getVersion(), artifact.file.toPath());
                    continue;
                }
                catch (AppModelResolverException e) {
                    throw new GradleException("Failed to import platform properties " + artifact.file, (Throwable)e);
                }
            }
            if (artifact == null || !artifact.file.getName().endsWith(".json")) continue;
            platformImports.addPlatformDescriptor(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), moduleVersionIdentifier.getVersion(), "json", moduleVersionIdentifier.getVersion());
        }
    }

    @TaskAction
    public void execute() throws IOException {
        ResolvedDependencyBuilder appArtifact = this.getProjectArtifact();
        PlatformImportsImpl platformImports = new PlatformImportsImpl();
        platformImports.setPlatformProperties((Map)this.getPlatformImportProperties().get());
        Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifactsByCapability = this.getPlatformConfiguration().resolvedArtifactsByComponentIdentifier();
        ((ResolvedComponentResult)this.getPlatformConfiguration().getRoot().get()).getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                this.collectPlatforms((ResolvedDependencyResult)d, artifactsByCapability, platformImports);
            }
        });
        ApplicationModelBuilder modelBuilder = new ApplicationModelBuilder().setAppArtifact(appArtifact).setPlatformImports((PlatformImports)platformImports).addReloadableWorkspaceModule(appArtifact.getKey());
        QuarkusApplicationModelTask.collectDependencies(this.getAppClasspath(), modelBuilder, appArtifact.getWorkspaceModule().mutable());
        QuarkusApplicationModelTask.collectExtensionDependencies(this.getDeploymentClasspath(), modelBuilder);
        ToolingUtils.serializeAppModel((ApplicationModel)modelBuilder.build(), (Path)((RegularFile)this.getApplicationModel().get()).getAsFile().toPath());
    }

    private ResolvedDependencyBuilder getProjectArtifact() {
        ModuleVersionIdentifier moduleVersion = ((ResolvedComponentResult)this.getAppClasspath().getRoot().get()).getModuleVersion();
        ResolvedDependencyBuilder appArtifact = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(moduleVersion.getGroup())).setArtifactId(moduleVersion.getName())).setVersion(moduleVersion.getVersion());
        WorkspaceModule.Mutable mainModule = WorkspaceModule.builder().setModuleId((WorkspaceModuleId)new GAV(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion())).setModuleDir(this.getLayout().getProjectDirectory().getAsFile().toPath()).setBuildDir(((File)this.getLayout().getBuildDirectory().getAsFile().get()).toPath()).setBuildFile(((File)this.getProjectBuildFile().getAsFile().get()).toPath());
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptor().get();
        QuarkusApplicationModelTask.initProjectModule(projectDescriptor, mainModule, "", "", ((DefaultProjectDescriptor)this.getProjectDescriptor().get()).getSourceSetTasksRaw());
        if (((LaunchMode)this.getLaunchMode().get()).isDevOrTest()) {
            QuarkusApplicationModelTask.initProjectModule(projectDescriptor, mainModule, "tests", "tests", ((DefaultProjectDescriptor)this.getProjectDescriptor().get()).getSourceSetTasksRaw());
        }
        PathList.Builder paths = PathList.builder();
        QuarkusApplicationModelTask.collectDestinationDirs(mainModule.getMainSources().getSourceDirs(), paths);
        QuarkusApplicationModelTask.collectDestinationDirs(mainModule.getMainSources().getResourceDirs(), paths);
        return appArtifact.setWorkspaceModule((WorkspaceModule)mainModule).setResolvedPaths((PathCollection)paths.build());
    }

    private static void initProjectModule(DefaultProjectDescriptor projectDescriptor, WorkspaceModule.Mutable module, String sourceSetName, String classifier, Map<String, Set<String>> sourceSetTasksRaw) {
        ArrayList<DefaultSourceDir> sourceDirs = new ArrayList<DefaultSourceDir>();
        ArrayList<DefaultSourceDir> resources = new ArrayList<DefaultSourceDir>();
        Set<String> tasks = projectDescriptor.getTasksForSourceSet(sourceSetName.isEmpty() ? "main" : (sourceSetName.equals("tests") ? "test" : sourceSetName));
        for (String task : tasks) {
            ProjectDescriptor.TaskType type = projectDescriptor.getTaskType(task);
            Path source = Path.of(projectDescriptor.getTaskSource(task), new String[0]);
            Path destDir = Path.of(projectDescriptor.getTaskDestinationDir(task), new String[0]);
            if (type == ProjectDescriptor.TaskType.COMPILE) {
                sourceDirs.add(new DefaultSourceDir(source, destDir, null, Map.of("compiler", task)));
                continue;
            }
            if (type != ProjectDescriptor.TaskType.RESOURCES) continue;
            resources.add(new DefaultSourceDir(source, destDir, null));
        }
        boolean containsJavaCompile = sourceDirs.stream().anyMatch(sourceDir -> "compileJava".equals(sourceDir.getValue((Object)"compiler", String.class)));
        if (!containsJavaCompile && sourceSetTasksRaw.get("compileJava") != null) {
            sourceSetTasksRaw.get("compileJava").forEach(s -> {
                File output = new File((String)s);
                if (output.exists() && Objects.requireNonNull(output.listFiles()).length > 0) {
                    sourceDirs.add(new DefaultSourceDir(output.toPath(), output.toPath(), null, Map.of("compiler", "compileJava")));
                }
            });
        }
        module.addArtifactSources((ArtifactSources)new DefaultArtifactSources(classifier, sourceDirs, resources));
    }

    private static void collectDestinationDirs(Collection<SourceDir> sources, PathList.Builder paths) {
        for (SourceDir src : sources) {
            Path path = src.getOutputDir();
            if (paths.contains(path) || !Files.exists(path, new LinkOption[0])) continue;
            paths.add(path);
        }
    }

    private static void collectDependencies(QuarkusResolvedClasspath classpath, ApplicationModelBuilder modelBuilder, WorkspaceModule.Mutable wsModule) {
        Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifacts = classpath.resolvedArtifactsByComponentIdentifier();
        HashSet alreadyCollectedFiles = new HashSet(artifacts.size());
        ((ResolvedComponentResult)classpath.getRoot().get()).getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                byte flags = 7;
                QuarkusApplicationModelTask.collectDependencies((ResolvedDependencyResult)d, modelBuilder, artifacts, wsModule, alreadyCollectedFiles, new HashSet<ArtifactKey>(), flags);
            }
        });
        HashSet<File> fileDependencies = new HashSet<File>(classpath.getAllResolvedFiles().getFiles());
        fileDependencies.removeAll(alreadyCollectedFiles);
        QuarkusApplicationModelTask.fileDependenciesExtractor(modelBuilder, fileDependencies);
    }

    private static void fileDependenciesExtractor(ApplicationModelBuilder modelBuilder, Set<File> fileDependencies) {
        for (File f : fileDependencies) {
            int dot;
            if (!f.exists()) continue;
            String parentPath = f.getParent();
            String group = HashUtil.sha1((String)(parentPath == null ? f.getName() : parentPath));
            String name = f.getName();
            String type = "jar";
            if (!f.isDirectory() && (dot = f.getName().lastIndexOf(46)) > 0) {
                name = f.getName().substring(0, dot);
                type = f.getName().substring(dot + 1);
            }
            String version = String.valueOf(f.lastModified());
            ResolvedDependencyBuilder artifactBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(group)).setArtifactId(name)).setType(type)).setVersion(version)).setResolvedPath(f.toPath()).setDirect(true)).setRuntimeCp()).setDeploymentCp();
            Utils.processQuarkusDependency(artifactBuilder, modelBuilder);
            modelBuilder.addDependency(artifactBuilder);
        }
    }

    private static void collectDependencies(ResolvedDependencyResult resolvedDependency, ApplicationModelBuilder modelBuilder, Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> resolvedArtifacts, WorkspaceModule.Mutable parentModule, Set<File> collectedArtifactFiles, Set<ArtifactKey> processedModules, byte flags) {
        WorkspaceModule projectModule = null;
        List<QuarkusResolvedArtifact> artifacts = QuarkusApplicationModelTask.findArtifacts(resolvedDependency, resolvedArtifacts);
        if (artifacts.isEmpty()) {
            byte finalFlags = flags;
            resolvedDependency.getSelected().getDependencies().forEach(dependencyResult -> {
                ModuleVersionIdentifier dependencyId;
                if (dependencyResult instanceof ResolvedDependencyResult && !processedModules.contains(new GACT((dependencyId = (ModuleVersionIdentifier)Preconditions.checkNotNull((Object)((ResolvedDependencyResult)dependencyResult).getSelected().getModuleVersion())).getGroup(), dependencyId.getName()))) {
                    QuarkusApplicationModelTask.collectDependencies((ResolvedDependencyResult)dependencyResult, modelBuilder, resolvedArtifacts, projectModule, collectedArtifactFiles, processedModules, finalFlags);
                }
            });
            return;
        }
        ModuleVersionIdentifier moduleVersionIdentifier = (ModuleVersionIdentifier)Preconditions.checkNotNull((Object)resolvedDependency.getSelected().getModuleVersion());
        for (QuarkusResolvedArtifact artifact : artifacts) {
            PathList paths;
            String classifier = QuarkusApplicationModelTask.resolveClassifier(moduleVersionIdentifier, artifact.file);
            GACT artifactKey = new GACT(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), classifier, artifact.type);
            if (!QuarkusApplicationModelTask.isDependency(artifact) || modelBuilder.getDependency((ArtifactKey)artifactKey) != null) continue;
            GACTV depCoords = new GACTV((ArtifactKey)artifactKey, moduleVersionIdentifier.getVersion());
            ResolvedDependencyBuilder depBuilder = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords((ArtifactCoords)depCoords)).setRuntimeCp()).setDeploymentCp();
            if (GradleApplicationModelBuilder.isFlagOn((byte)flags, (byte)2)) {
                depBuilder.setDirect(true);
                flags = GradleApplicationModelBuilder.clearFlag((byte)flags, (byte)2);
            }
            if (parentModule != null) {
                parentModule.addDependency((Dependency)new ArtifactDependency((ArtifactCoords)depCoords, new int[0]));
            }
            depBuilder.setResolvedPaths((paths = null) == null ? PathList.of((Path[])new Path[]{artifact.file.toPath()}) : paths).setWorkspaceModule(projectModule);
            if (Utils.processQuarkusDependency(depBuilder, modelBuilder)) {
                if (GradleApplicationModelBuilder.isFlagOn((byte)flags, (byte)1)) {
                    depBuilder.setFlags(128);
                    flags = GradleApplicationModelBuilder.clearFlag((byte)flags, (byte)1);
                }
                flags = GradleApplicationModelBuilder.clearFlag((byte)flags, (byte)4);
            }
            if (!GradleApplicationModelBuilder.isFlagOn((byte)flags, (byte)4)) {
                depBuilder.clearFlag(64);
            }
            modelBuilder.addDependency(depBuilder);
            collectedArtifactFiles.add(artifact.file);
        }
        processedModules.add(ArtifactKey.ga((String)moduleVersionIdentifier.getGroup(), (String)moduleVersionIdentifier.getName()));
        for (DependencyResult dependency : resolvedDependency.getSelected().getDependencies()) {
            ModuleVersionIdentifier dependencyId;
            if (!(dependency instanceof ResolvedDependencyResult) || processedModules.contains(new GACT((dependencyId = (ModuleVersionIdentifier)Preconditions.checkNotNull((Object)((ResolvedDependencyResult)dependency).getSelected().getModuleVersion())).getGroup(), dependencyId.getName()))) continue;
            QuarkusApplicationModelTask.collectDependencies((ResolvedDependencyResult)dependency, modelBuilder, resolvedArtifacts, projectModule, collectedArtifactFiles, processedModules, flags);
        }
    }

    private static boolean isDependency(QuarkusResolvedArtifact a) {
        return a.file.getName().endsWith("jar") || a.file.getName().endsWith(".exe") || a.file.isDirectory();
    }

    private static void collectExtensionDependencies(QuarkusResolvedClasspath classpath, ApplicationModelBuilder modelBuilder) {
        Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifacts = classpath.resolvedArtifactsByComponentIdentifier();
        HashSet alreadyVisited = new HashSet();
        ((ResolvedComponentResult)classpath.getRoot().get()).getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                QuarkusApplicationModelTask.collectExtensionDependencies((ResolvedDependencyResult)d, modelBuilder, artifacts, alreadyVisited);
            }
        });
    }

    private static void collectExtensionDependencies(ResolvedDependencyResult resolvedDependency, ApplicationModelBuilder modelBuilder, Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> resolvedArtifacts, Set<ArtifactKey> alreadyVisited) {
        List<QuarkusResolvedArtifact> artifacts = QuarkusApplicationModelTask.findArtifacts(resolvedDependency, resolvedArtifacts);
        if (artifacts.isEmpty()) {
            return;
        }
        for (QuarkusResolvedArtifact artifact : artifacts) {
            ModuleVersionIdentifier moduleVersionIdentifier = (ModuleVersionIdentifier)Preconditions.checkNotNull((Object)resolvedDependency.getSelected().getModuleVersion());
            String classifier = QuarkusApplicationModelTask.resolveClassifier(moduleVersionIdentifier, artifact.file);
            GACT artifactKey = new GACT(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), classifier, artifact.type);
            if (!alreadyVisited.add((ArtifactKey)artifactKey)) {
                return;
            }
            ResolvedDependencyBuilder dep = modelBuilder.getDependency((ArtifactKey)artifactKey);
            if (dep == null) {
                GACTV artifactCoords = new GACTV((ArtifactKey)artifactKey, moduleVersionIdentifier.getVersion());
                dep = QuarkusApplicationModelTask.toDependency((ArtifactCoords)artifactCoords, artifact.file, new int[0]);
                modelBuilder.addDependency(dep);
            }
            dep.setDeploymentCp();
            dep.clearFlag(64);
        }
        resolvedDependency.getSelected().getDependencies().forEach(d -> {
            if (d instanceof ResolvedDependencyResult) {
                QuarkusApplicationModelTask.collectExtensionDependencies((ResolvedDependencyResult)d, modelBuilder, resolvedArtifacts, alreadyVisited);
            }
        });
    }

    private static List<QuarkusResolvedArtifact> findArtifacts(ResolvedDependencyResult resolvedDependency, Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> artifacts) {
        return artifacts.getOrDefault(resolvedDependency.getSelected().getId(), Collections.emptyList());
    }

    private static String resolveClassifier(ModuleVersionIdentifier moduleVersionIdentifier, File file) {
        String artifactIdVersion;
        String string = artifactIdVersion = moduleVersionIdentifier.getVersion().isEmpty() || "unspecified".equals(moduleVersionIdentifier.getVersion()) ? moduleVersionIdentifier.getName() : moduleVersionIdentifier.getName() + "-" + moduleVersionIdentifier.getVersion();
        if ((file.getName().endsWith(".jar") || file.getName().endsWith(".pom") || file.getName().endsWith(".exe")) && file.getName().startsWith(artifactIdVersion + "-")) {
            int extensionLength = file.getName().endsWith(".exe") ? 4 : 4;
            return file.getName().substring(artifactIdVersion.length() + 1, file.getName().length() - extensionLength);
        }
        return "";
    }

    static ResolvedDependencyBuilder toDependency(ArtifactCoords artifactCoords, File file, int ... flags) {
        int allFlags = 0;
        for (int f : flags) {
            allFlags |= f;
        }
        PathList paths = PathList.of((Path[])new Path[]{file.toPath()});
        return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(artifactCoords)).setResolvedPaths((PathCollection)paths).setFlags(allFlags);
    }

    public static class QuarkusResolvedArtifact
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ComponentArtifactIdentifier id;
        private final String type;
        private final File file;

        public QuarkusResolvedArtifact(ComponentArtifactIdentifier id, File file, String type) {
            this.id = id;
            this.type = type;
            this.file = file;
        }

        public ComponentArtifactIdentifier getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static abstract class QuarkusResolvedClasspath {
        @Internal
        public abstract Property<ResolvedComponentResult> getRoot();

        @Internal
        public abstract Property<ArtifactCollection> getResolvedArtifactCollection();

        @Internal
        public abstract ConfigurableFileCollection getProjectDescriptors();

        private FileCollection getAllResolvedFiles() {
            return ((ArtifactCollection)this.getResolvedArtifactCollection().get()).getArtifactFiles();
        }

        private Map<ComponentIdentifier, List<QuarkusResolvedArtifact>> resolvedArtifactsByComponentIdentifier() {
            return this.getQuarkusResolvedArtifacts().stream().collect(Collectors.groupingBy(artifact -> artifact.getId().getComponentIdentifier()));
        }

        private List<QuarkusResolvedArtifact> getQuarkusResolvedArtifacts() {
            return ((ArtifactCollection)this.getResolvedArtifactCollection().get()).getArtifacts().stream().map(this::toResolvedArtifact).collect(Collectors.toList());
        }

        private QuarkusResolvedArtifact toResolvedArtifact(ResolvedArtifactResult result) {
            String type = (String)result.getVariant().getAttributes().getAttribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
            File file = result.getFile();
            return new QuarkusResolvedArtifact(result.getId(), file, type);
        }

        public void configureFrom(Configuration configuration) {
            ResolvableDependencies resolvableDependencies = configuration.getIncoming();
            this.getRoot().set(resolvableDependencies.getResolutionResult().getRootComponent());
            this.getResolvedArtifactCollection().set((Object)resolvableDependencies.getArtifacts());
            this.getProjectDescriptors().setFrom((Iterable)configuration.getIncoming().artifactView(viewConfiguration -> {
                viewConfiguration.withVariantReselection();
                viewConfiguration.componentFilter(component -> component instanceof ProjectComponentIdentifier);
                viewConfiguration.attributes(attributes -> attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)QuarkusApplicationModelTask.QUARKUS_PROJECT_DESCRIPTOR_ARTIFACT_TYPE));
            }).getFiles());
        }
    }

    public static class Utils {
        public static boolean processQuarkusDependency(ResolvedDependencyBuilder artifactBuilder, ApplicationModelBuilder modelBuilder) {
            Path artifactPath;
            Iterator iterator = artifactBuilder.getResolvedPaths().iterator();
            if (iterator.hasNext() && Files.exists(artifactPath = (Path)iterator.next(), new LinkOption[0]) && artifactBuilder.getType().equals("jar")) {
                boolean bl;
                block10: {
                    if (Files.isDirectory(artifactPath, new LinkOption[0])) {
                        return Utils.processQuarkusDir(artifactBuilder, artifactPath.resolve("META-INF"), modelBuilder);
                    }
                    FileSystem artifactFs = ZipUtils.newFileSystem((Path)artifactPath);
                    try {
                        bl = Utils.processQuarkusDir(artifactBuilder, artifactFs.getPath("META-INF", new String[0]), modelBuilder);
                        if (artifactFs == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (artifactFs != null) {
                                try {
                                    artifactFs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to process " + artifactPath, e);
                        }
                    }
                    artifactFs.close();
                }
                return bl;
            }
            return false;
        }

        private static boolean processQuarkusDir(ResolvedDependencyBuilder artifactBuilder, Path quarkusDir, ApplicationModelBuilder modelBuilder) {
            if (!Files.exists(quarkusDir, new LinkOption[0])) {
                return false;
            }
            Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
            if (!Files.exists(quarkusDescr, new LinkOption[0])) {
                return false;
            }
            Properties extProps = Utils.readDescriptor(quarkusDescr);
            if (extProps == null) {
                return false;
            }
            artifactBuilder.setRuntimeExtensionArtifact();
            String extensionCoords = artifactBuilder.toGACTVString();
            modelBuilder.handleExtensionProperties(extProps, extensionCoords);
            String providesCapabilities = extProps.getProperty("provides-capabilities");
            if (providesCapabilities != null) {
                modelBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.of((String)extensionCoords, (String)providesCapabilities, null));
            }
            return true;
        }

        private static Properties readDescriptor(Path path) {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            Properties rtProps = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(path);){
                rtProps.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load extension description " + path, e);
            }
            return rtProps;
        }
    }

    public static class QuarkusCapability {
    }
}

