/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class ImageCheckRequirementsTask
extends DefaultTask {
    private static final String DEPLOYMENT_SUFFIX = "-deployment";
    static final String QUARKUS_PREFIX = "quarkus-";
    static final String QUARKUS_CONTAINER_IMAGE_PREFIX = "quarkus-container-image-";
    static final String QUARKUS_CONTAINER_IMAGE_BUILD = "quarkus.container-image.build";
    static final String QUARKUS_CONTAINER_IMAGE_PUSH = "quarkus.container-image.push";
    static final String QUARKUS_CONTAINER_IMAGE_BUILDER = "quarkus.container-image.builder";
    static final Map<String, Builder> BUILDERS = new HashMap<String, Builder>();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getApplicationModel();

    Optional<Builder> builderFromSystemProperties() {
        return Optional.ofNullable(System.getProperty(QUARKUS_CONTAINER_IMAGE_BUILDER)).filter(BUILDERS::containsKey).map(BUILDERS::get);
    }

    List<Builder> availableBuilders() throws IOException {
        ApplicationModel appModel = ToolingUtils.deserializeAppModel((Path)((RegularFile)this.getApplicationModel().get()).getAsFile().toPath());
        return appModel.getDependencies().stream().map(ArtifactCoords::getArtifactId).filter(n -> n.startsWith(QUARKUS_CONTAINER_IMAGE_PREFIX) || n.startsWith(QUARKUS_PREFIX)).map(n -> n.replace(QUARKUS_CONTAINER_IMAGE_PREFIX, "").replace(QUARKUS_PREFIX, "").replace(DEPLOYMENT_SUFFIX, "")).filter(BUILDERS::containsKey).map(BUILDERS::get).collect(Collectors.toList());
    }

    private Builder builder() {
        return this.builderFromSystemProperties().or(() -> {
            try {
                return this.availableBuilders().stream().findFirst();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(Builder.docker);
    }

    @TaskAction
    public void checkRequiredExtensions() throws IOException {
        List<Builder> availableBuidlers = this.availableBuilders();
        Optional<Builder> missingBuilder = Optional.of(this.builder()).filter(Predicate.not(availableBuidlers::contains));
        missingBuilder.map(builder -> QUARKUS_CONTAINER_IMAGE_PREFIX + builder.name()).ifPresent(missingDependency -> {
            throw new GradleException(String.format("Task: %s requires extensions: %s. To add the extensions to the project, you can run the following command:\n\tgradle addExtension --extensions=%s", this.getName(), missingDependency, missingDependency));
        });
        if (!missingBuilder.isPresent() && availableBuidlers.isEmpty()) {
            String availableExtensions = Arrays.stream(Builder.values()).map(Enum::name).collect(Collectors.joining(", ", "[", "]"));
            throw new GradleException(String.format("Task: %s requires one of the extensions: %s. To add the extensions to the project, you can run the following command:\n\tgradle addExtension --extensions=<extension name>", this.getName(), availableExtensions));
        }
        File outputFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        Files.write(outputFile.toPath(), this.builder().name().getBytes(), new OpenOption[0]);
    }

    static {
        for (Builder builder : Builder.values()) {
            BUILDERS.put(builder.name(), builder);
        }
    }

    static enum Builder {
        docker,
        jib,
        buildpack,
        openshift;

    }
}

