/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.tasks.QuarkusBuildTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.tasks.TaskAction;

public abstract class ImageTask
extends QuarkusBuildTask {
    static final String QUARKUS_PREFIX = "quarkus-";
    static final String QUARKUS_CONTAINER_IMAGE_PREFIX = "quarkus-container-image-";
    static final String QUARKUS_CONTAINER_IMAGE_BUILD = "quarkus.container-image.build";
    static final String QUARKUS_CONTAINER_IMAGE_PUSH = "quarkus.container-image.push";
    static final String QUARKUS_CONTAINER_IMAGE_BUILDER = "quarkus.container-image.builder";
    static final Map<String, Builder> BUILDERS = new HashMap<String, Builder>();

    public ImageTask(String description) {
        super(description);
    }

    public Builder builder() {
        return this.builderFromSystemProperties().or(() -> this.availableBuilders().stream().findFirst()).orElse(Builder.docker);
    }

    Optional<Builder> builderFromSystemProperties() {
        return Optional.ofNullable(System.getProperty(QUARKUS_CONTAINER_IMAGE_BUILDER)).filter(BUILDERS::containsKey).map(BUILDERS::get);
    }

    List<Builder> availableBuilders() {
        return this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).filter(n -> n.startsWith(QUARKUS_CONTAINER_IMAGE_PREFIX) || n.startsWith(QUARKUS_PREFIX)).map(n -> n.replace(QUARKUS_CONTAINER_IMAGE_PREFIX, "").replace(QUARKUS_PREFIX, "")).filter(BUILDERS::containsKey).map(BUILDERS::get).collect(Collectors.toList());
    }

    @TaskAction
    public void checkRequiredExtensions() {
        List<Builder> availableBuidlers = this.availableBuilders();
        Optional<Builder> missingBuilder = Optional.of(this.builder()).filter(Predicate.not(availableBuidlers::contains));
        missingBuilder.map(builder -> QUARKUS_CONTAINER_IMAGE_PREFIX + builder.name()).ifPresent(missingDependency -> {
            this.getLogger().warn("Task: {} requires extensions: {}", (Object)this.getName(), missingDependency);
            this.getLogger().warn("To add the extensions to the project you can run the following command:");
            this.getLogger().warn("\tgradle addExtension --extensions={}", missingDependency);
            this.abort("Aborting.", new Object[0]);
        });
        if (!missingBuilder.isPresent() && availableBuidlers.isEmpty()) {
            this.getLogger().warn("Task: {} requires on of extensions: {}", (Object)this.getName(), (Object)Arrays.stream(Builder.values()).map(Enum::name).collect(Collectors.joining(", ", "[", "]")));
            this.getLogger().warn("To add the extensions to the project you can run the following command:");
            this.getLogger().warn("\tgradle addExtension --extensions=<extension name>");
            this.abort("Aborting.", new Object[0]);
        }
    }

    static {
        for (Builder builder : Builder.values()) {
            BUILDERS.put(builder.name(), builder);
        }
    }

    static enum Builder {
        docker,
        jib,
        buildpack,
        openshift;

    }
}

