/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.ArrayTypeImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassTypeImpl;
import io.quarkus.arc.processor.bcextensions.ParameterizedTypeImpl;
import io.quarkus.arc.processor.bcextensions.PrimitiveTypeImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import io.quarkus.arc.processor.bcextensions.VoidTypeImpl;
import io.quarkus.arc.processor.bcextensions.WildcardTypeImpl;
import jakarta.enterprise.inject.build.compatible.spi.Types;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.ArrayType;
import jakarta.enterprise.lang.model.types.ClassType;
import jakarta.enterprise.lang.model.types.ParameterizedType;
import jakarta.enterprise.lang.model.types.PrimitiveType;
import jakarta.enterprise.lang.model.types.VoidType;
import jakarta.enterprise.lang.model.types.WildcardType;
import java.util.Arrays;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

class TypesImpl
implements Types {
    private final IndexView jandexIndex;
    private final AllAnnotationOverlays annotationOverlays;

    TypesImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
    }

    public jakarta.enterprise.lang.model.types.Type of(Class<?> clazz) {
        if (clazz.isArray()) {
            int dimensions = 1;
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                ++dimensions;
                componentType = componentType.getComponentType();
            }
            return this.ofArray(this.of(componentType), dimensions);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return this.ofVoid();
            }
            if (clazz == Boolean.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.BOOLEAN);
            }
            if (clazz == Byte.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.BYTE);
            }
            if (clazz == Short.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.SHORT);
            }
            if (clazz == Integer.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.INT);
            }
            if (clazz == Long.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.LONG);
            }
            if (clazz == Float.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.FLOAT);
            }
            if (clazz == Double.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.DOUBLE);
            }
            if (clazz == Character.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.CHAR);
            }
            throw new IllegalArgumentException("Unknown primitive type " + clazz);
        }
        Type jandexType = Type.create((DotName)DotName.createSimple((String)clazz.getName()), (Type.Kind)Type.Kind.CLASS);
        return new ClassTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType.asClassType());
    }

    public VoidType ofVoid() {
        Type jandexType = Type.create((DotName)DotName.createSimple((String)"void"), (Type.Kind)Type.Kind.VOID);
        return new VoidTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType.asVoidType());
    }

    public PrimitiveType ofPrimitive(PrimitiveType.PrimitiveKind kind) {
        Type jandexType = Type.create((DotName)DotName.createSimple((String)kind.name().toLowerCase()), (Type.Kind)Type.Kind.PRIMITIVE);
        return new PrimitiveTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType.asPrimitiveType());
    }

    public ClassType ofClass(ClassInfo clazz) {
        Type jandexType = Type.create((DotName)((org.jboss.jandex.ClassInfo)((ClassInfoImpl)clazz).jandexDeclaration).name(), (Type.Kind)Type.Kind.CLASS);
        return new ClassTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType.asClassType());
    }

    public ClassType ofClass(String name) {
        DotName className = DotName.createSimple((String)name);
        org.jboss.jandex.ClassInfo jandexClass = this.jandexIndex.getClassByName(className);
        if (jandexClass == null) {
            return null;
        }
        Type jandexType = Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS);
        return new ClassTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType.asClassType());
    }

    public ArrayType ofArray(jakarta.enterprise.lang.model.types.Type componentType, int dimensions) {
        org.jboss.jandex.ArrayType jandexType = org.jboss.jandex.ArrayType.create(((TypeImpl)componentType).jandexType, (int)dimensions);
        return new ArrayTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType);
    }

    public ParameterizedType parameterized(Class<?> genericType, Class<?> ... typeArguments) {
        DotName genericTypeName = DotName.createSimple((String)genericType.getName());
        jakarta.enterprise.lang.model.types.Type[] transformedTypeArguments = (jakarta.enterprise.lang.model.types.Type[])Arrays.stream(typeArguments).map(this::of).toArray(jakarta.enterprise.lang.model.types.Type[]::new);
        return this.parameterizedType(genericTypeName, transformedTypeArguments);
    }

    public ParameterizedType parameterized(Class<?> genericType, jakarta.enterprise.lang.model.types.Type ... typeArguments) {
        DotName genericTypeName = DotName.createSimple((String)genericType.getName());
        return this.parameterizedType(genericTypeName, typeArguments);
    }

    public ParameterizedType parameterized(ClassType genericType, jakarta.enterprise.lang.model.types.Type ... typeArguments) {
        DotName genericTypeName = ((TypeImpl)genericType).jandexType.name();
        return this.parameterizedType(genericTypeName, typeArguments);
    }

    private ParameterizedType parameterizedType(DotName genericTypeName, jakarta.enterprise.lang.model.types.Type ... typeArguments) {
        Type[] jandexTypeArguments = (Type[])Arrays.stream(typeArguments).map(it -> ((TypeImpl)it).jandexType).toArray(Type[]::new);
        org.jboss.jandex.ParameterizedType jandexType = org.jboss.jandex.ParameterizedType.create((DotName)genericTypeName, (Type[])jandexTypeArguments, null);
        return new ParameterizedTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType);
    }

    public WildcardType wildcardWithUpperBound(jakarta.enterprise.lang.model.types.Type upperBound) {
        org.jboss.jandex.WildcardType jandexType = org.jboss.jandex.WildcardType.createUpperBound(((TypeImpl)upperBound).jandexType);
        return new WildcardTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType);
    }

    public WildcardType wildcardWithLowerBound(jakarta.enterprise.lang.model.types.Type lowerBound) {
        org.jboss.jandex.WildcardType jandexType = org.jboss.jandex.WildcardType.createLowerBound(((TypeImpl)lowerBound).jandexType);
        return new WildcardTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType);
    }

    public WildcardType wildcardUnbounded() {
        org.jboss.jandex.WildcardType jandexType = org.jboss.jandex.WildcardType.create(null, (boolean)true);
        return new WildcardTypeImpl(this.jandexIndex, this.annotationOverlays, jandexType);
    }
}

