/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.otlp;

import com.google.common.base.Splitter;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.exporters.otlp.SpanAdapter;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    public static final String DEFAULT_ENDPOINT = "localhost:55680";
    public static final long DEFAULT_DEADLINE_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final Logger logger = Logger.getLogger(OtlpGrpcSpanExporter.class.getName());
    private static final boolean DEFAULT_USE_TLS = false;
    private final TraceServiceGrpc.TraceServiceFutureStub traceService;
    private final ManagedChannel managedChannel;
    private final long deadlineMs;

    private OtlpGrpcSpanExporter(ManagedChannel channel, long deadlineMs) {
        this.managedChannel = channel;
        this.deadlineMs = deadlineMs;
        this.traceService = TraceServiceGrpc.newFutureStub((Channel)channel);
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        ExportTraceServiceRequest exportTraceServiceRequest = ExportTraceServiceRequest.newBuilder().addAllResourceSpans(SpanAdapter.toProtoResourceSpans(spans)).build();
        final CompletableResultCode result = new CompletableResultCode();
        TraceServiceGrpc.TraceServiceFutureStub exporter = this.deadlineMs > 0L ? (TraceServiceGrpc.TraceServiceFutureStub)this.traceService.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS) : this.traceService;
        Futures.addCallback((ListenableFuture)exporter.export(exportTraceServiceRequest), (FutureCallback)new FutureCallback<ExportTraceServiceResponse>(){

            public void onSuccess(@Nullable ExportTraceServiceResponse response) {
                result.succeed();
            }

            public void onFailure(Throwable t) {
                logger.log(Level.WARNING, "Failed to export spans", t);
                result.fail();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static OtlpGrpcSpanExporter getDefault() {
        return ((Builder)((Object)((Builder)((Object)OtlpGrpcSpanExporter.newBuilder().readEnvironmentVariables())).readSystemProperties())).build();
    }

    public CompletableResultCode shutdown() {
        final CompletableResultCode result = new CompletableResultCode();
        this.managedChannel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, new Runnable(){

            @Override
            public void run() {
                result.succeed();
            }
        });
        this.managedChannel.shutdown();
        return result;
    }

    public static class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_TIMEOUT = "otel.exporter.otlp.span.timeout";
        private static final String KEY_ENDPOINT = "otel.exporter.otlp.span.endpoint";
        private static final String KEY_INSECURE = "otel.exporter.otlp.span.insecure";
        private static final String KEY_HEADERS = "otel.exporter.otlp.span.headers";
        private ManagedChannel channel;
        private long deadlineMs = DEFAULT_DEADLINE_MS;
        private String endpoint = "localhost:55680";
        private boolean useTls = false;
        @Nullable
        private Metadata metadata;

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setDeadlineMs(long deadlineMs) {
            this.deadlineMs = deadlineMs;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setUseTls(boolean useTls) {
            this.useTls = useTls;
            return this;
        }

        public Builder addHeader(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new Metadata();
            }
            this.metadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
            return this;
        }

        public OtlpGrpcSpanExporter build() {
            if (this.channel == null) {
                ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint);
                if (this.useTls) {
                    managedChannelBuilder.useTransportSecurity();
                } else {
                    managedChannelBuilder.usePlaintext();
                }
                if (this.metadata != null) {
                    managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
                }
                this.channel = managedChannelBuilder.build();
            }
            return new OtlpGrpcSpanExporter(this.channel, this.deadlineMs);
        }

        private Builder() {
        }

        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            String metadataValue;
            Boolean insecure;
            String endpointValue;
            Long value = Builder.getLongProperty((String)KEY_TIMEOUT, (Map)(configMap = namingConvention.normalize(configMap)));
            if (value == null) {
                value = Builder.getLongProperty((String)"otel.exporter.otlp.timeout", (Map)configMap);
            }
            if (value != null) {
                this.setDeadlineMs(value);
            }
            if ((endpointValue = Builder.getStringProperty((String)KEY_ENDPOINT, (Map)configMap)) == null) {
                endpointValue = Builder.getStringProperty((String)"otel.exporter.otlp.endpoint", (Map)configMap);
            }
            if (endpointValue != null) {
                this.setEndpoint(endpointValue);
            }
            if ((insecure = Builder.getBooleanProperty((String)KEY_INSECURE, (Map)configMap)) == null) {
                insecure = Builder.getBooleanProperty((String)"otel.exporter.otlp.insecure", (Map)configMap);
            }
            if (insecure != null) {
                this.setUseTls(insecure == false);
            }
            if ((metadataValue = Builder.getStringProperty((String)KEY_HEADERS, (Map)configMap)) == null) {
                metadataValue = Builder.getStringProperty((String)"otel.exporter.otlp.headers", (Map)configMap);
            }
            if (metadataValue != null) {
                for (String keyValueString : Splitter.on((char)';').split((CharSequence)metadataValue)) {
                    List keyValue = Splitter.on((char)'=').limit(2).trimResults().omitEmptyStrings().splitToList((CharSequence)keyValueString);
                    if (keyValue.size() != 2) continue;
                    this.addHeader((String)keyValue.get(0), (String)keyValue.get(1));
                }
            }
            return this;
        }
    }
}

