/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.PluginConfigSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class CreateServerMojo
extends PluginConfigSupport {
    @Parameter(property="template")
    private String template;
    @Parameter(property="libertySettingsFolder", defaultValue="${basedir}/src/main/resources/etc")
    private File libertySettingsFolder;
    @Parameter(property="noPassword", defaultValue="false")
    private boolean noPassword;

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping create goal.\n");
            return;
        }
        this.doCreateServer();
    }

    private void doCreateServer() throws MojoExecutionException {
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
        }
        boolean createServer = false;
        if (!this.serverDirectory.exists()) {
            createServer = true;
        } else if (this.refresh) {
            try {
                FileUtils.forceDelete((File)this.serverDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error deleting existing server directory " + this.serverDirectory.getAbsolutePath() + ". Cannot refresh the server.", (Exception)e);
            }
            createServer = true;
        }
        if (createServer) {
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.start.create"), this.serverName));
            ServerTask serverTask = this.initializeJava();
            serverTask.setOperation("create");
            serverTask.setTemplate(this.template);
            serverTask.setNoPassword(this.noPassword);
            serverTask.execute();
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.server.create.created"), this.serverName, this.serverDirectory.getAbsolutePath()));
        }
        try {
            this.copyConfigFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying configuration files to Liberty server directory.", (Exception)e);
        }
        try {
            this.copyLibertySettings();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying Liberty settings from directory " + this.libertySettingsFolder.getAbsolutePath() + " to Liberty server directory.", (Exception)e);
        }
    }

    private void copyLibertySettings() throws MojoExecutionException, IOException {
        if (this.libertySettingsFolder.exists()) {
            if (!this.libertySettingsFolder.isDirectory()) {
                throw new MojoExecutionException("The Liberty configuration <libertySettingsFolder> must be a directory. Value found: " + this.libertySettingsFolder.toString());
            }
            this.getLog().info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "libertySettingsFolder", this.libertySettingsFolder));
            File[] files = this.libertySettingsFolder.listFiles();
            if (files != null && files.length > 0) {
                File installDir = new File(this.installDirectory + "/etc");
                if (!installDir.exists()) {
                    installDir.mkdirs();
                }
                this.getLog().info((CharSequence)("Copying " + files.length + " file" + (files.length == 1 ? "" : "s") + " to " + installDir.getCanonicalPath()));
                FileUtils.copyDirectory((File)this.libertySettingsFolder, (File)installDir);
            } else {
                this.getLog().info((CharSequence)"No custom Liberty configuration files found.");
            }
        } else {
            this.getLog().debug((CharSequence)"No custom Liberty configuration folder found.");
        }
    }
}

