/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp.multihoming;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.nio.NioSctpServerChannel;
import io.netty.example.sctp.SctpEchoServerHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class SctpMultiHomingEchoServer {
    private static final String SERVER_PRIMARY_HOST = System.getProperty("host.primary", "127.0.0.1");
    private static final String SERVER_SECONDARY_HOST = System.getProperty("host.secondary", "127.0.0.2");
    private static final int SERVER_PORT = Integer.parseInt(System.getProperty("port", "8007"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioSctpServerChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SctpChannel>(){

                public void initChannel(SctpChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new SctpEchoServerHandler()});
                }
            });
            InetSocketAddress localAddress = SocketUtils.socketAddress((String)SERVER_PRIMARY_HOST, (int)SERVER_PORT);
            InetAddress localSecondaryAddress = SocketUtils.addressByName((String)SERVER_SECONDARY_HOST);
            ChannelFuture bindFuture = b.bind((SocketAddress)localAddress).sync();
            SctpServerChannel channel = (SctpServerChannel)bindFuture.channel();
            ChannelFuture connectFuture = channel.bindAddress(localSecondaryAddress).sync();
            connectFuture.channel().closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

