/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.memcache.binary;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.memcache.binary.MemcacheClientHandler;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheClientCodec;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheObjectAggregator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public final class MemcacheClient {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "11211"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final SslContext sslCtx = SSL ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            String line;
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), HOST, PORT)});
                    }
                    p.addLast(new ChannelHandler[]{new BinaryMemcacheClientCodec()});
                    p.addLast(new ChannelHandler[]{new BinaryMemcacheObjectAggregator(Integer.MAX_VALUE)});
                    p.addLast(new ChannelHandler[]{new MemcacheClientHandler()});
                }
            });
            Channel ch = b.connect(HOST, PORT).sync().channel();
            System.out.println("Enter commands (quit to end)");
            System.out.println("get <key>");
            System.out.println("set <key> <value>");
            ChannelFuture lastWriteFuture = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                if ("quit".equals(line.toLowerCase())) {
                    ch.close().sync();
                    break;
                }
                lastWriteFuture = ch.writeAndFlush((Object)line);
            }
            if (lastWriteFuture != null) {
                lastWriteFuture.sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

