/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.ocsp;

import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.io.DigestOutputStream;
import org.bouncycastle.operator.DigestCalculator;

public final class Digester
implements DigestCalculator {
    private final DigestOutputStream dos;
    private final AlgorithmIdentifier algId;

    public static DigestCalculator sha1() {
        SHA1Digest digest = new SHA1Digest();
        AlgorithmIdentifier algId = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        return new Digester((Digest)digest, algId);
    }

    public static DigestCalculator sha256() {
        SHA256Digest digest = new SHA256Digest();
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1").intern();
        AlgorithmIdentifier algId = new AlgorithmIdentifier(oid);
        return new Digester((Digest)digest, algId);
    }

    private Digester(Digest digest, AlgorithmIdentifier algId) {
        this.dos = new DigestOutputStream(digest);
        this.algId = algId;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algId;
    }

    public OutputStream getOutputStream() {
        return this.dos;
    }

    public byte[] getDigest() {
        return this.dos.getDigest();
    }
}

