/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.frame.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http2.helloworld.frame.client.Http2ClientFrameInitializer;
import io.netty.example.http2.helloworld.frame.client.Http2ClientStreamFrameResponseHandler;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;

public final class Http2FrameClient {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", SSL ? "8443" : "8080"));
    static final String PATH = System.getProperty("path", "/");

    private Http2FrameClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SslContext sslCtx;
        NioEventLoopGroup clientWorkerGroup = new NioEventLoopGroup();
        if (SSL) {
            SslProvider provider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
            sslCtx = SslContextBuilder.forClient().sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
        } else {
            sslCtx = null;
        }
        try {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)clientWorkerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.remoteAddress(HOST, PORT);
            b.handler((ChannelHandler)new Http2ClientFrameInitializer(sslCtx));
            Channel channel = b.connect().syncUninterruptibly().channel();
            System.out.println("Connected to [" + HOST + ':' + PORT + ']');
            Http2ClientStreamFrameResponseHandler streamFrameResponseHandler = new Http2ClientStreamFrameResponseHandler();
            Http2StreamChannelBootstrap streamChannelBootstrap = new Http2StreamChannelBootstrap(channel);
            Http2StreamChannel streamChannel = (Http2StreamChannel)streamChannelBootstrap.open().syncUninterruptibly().getNow();
            streamChannel.pipeline().addLast(new ChannelHandler[]{streamFrameResponseHandler});
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.method((CharSequence)"GET");
            headers.path((CharSequence)PATH);
            headers.scheme((CharSequence)(SSL ? "https" : "http"));
            DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)headers);
            streamChannel.writeAndFlush((Object)headersFrame);
            System.out.println("Sent HTTP/2 GET request to " + PATH);
            if (!streamFrameResponseHandler.responseSuccessfullyCompleted()) {
                System.err.println("Did not get HTTP/2 response in expected time.");
            }
            System.out.println("Finished HTTP/2 request, will close the connection.");
            channel.close().syncUninterruptibly();
        }
        finally {
            clientWorkerGroup.shutdownGracefully();
        }
    }
}

