/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.Cleaner0;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.UnsafeAtomicIntegerFieldUpdater;
import io.netty.util.internal.UnsafeAtomicLongFieldUpdater;
import io.netty.util.internal.UnsafeAtomicReferenceFieldUpdater;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final InternalLogger logger;
    static final Unsafe UNSAFE;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long CHAR_ARRAY_BASE_OFFSET;
    private static final long CHAR_ARRAY_INDEX_SCALE;
    private static final long STRING_VALUE_FIELD_OFFSET;
    static final int HASH_CODE_ASCII_SEED = -1028477387;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable cause) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(cause, "cause"));
    }

    static void freeDirectBuffer(ByteBuffer buffer) {
        Cleaner0.freeDirectBuffer(buffer);
    }

    static long directBufferAddress(ByteBuffer buffer) {
        return PlatformDependent0.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long fieldOffset) {
        return UNSAFE.getObject(object, fieldOffset);
    }

    static Object getObjectVolatile(Object object, long fieldOffset) {
        return UNSAFE.getObjectVolatile(object, fieldOffset);
    }

    static int getInt(Object object, long fieldOffset) {
        return UNSAFE.getInt(object, fieldOffset);
    }

    private static long getLong(Object object, long fieldOffset) {
        return UNSAFE.getLong(object, fieldOffset);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long address) {
        return UNSAFE.getByte(address);
    }

    static short getShort(long address) {
        return UNSAFE.getShort(address);
    }

    static int getInt(long address) {
        return UNSAFE.getInt(address);
    }

    static long getLong(long address) {
        return UNSAFE.getLong(address);
    }

    static byte getByte(byte[] data, int index) {
        return UNSAFE.getByte(data, BYTE_ARRAY_BASE_OFFSET + (long)index);
    }

    static short getShort(byte[] data, int index) {
        return UNSAFE.getShort(data, BYTE_ARRAY_BASE_OFFSET + (long)index);
    }

    static int getInt(byte[] data, int index) {
        return UNSAFE.getInt(data, BYTE_ARRAY_BASE_OFFSET + (long)index);
    }

    static long getLong(byte[] data, int index) {
        return UNSAFE.getLong(data, BYTE_ARRAY_BASE_OFFSET + (long)index);
    }

    static void putOrderedObject(Object object, long address, Object value) {
        UNSAFE.putOrderedObject(object, address, value);
    }

    static void putByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    static void putShort(long address, short value) {
        UNSAFE.putShort(address, value);
    }

    static void putInt(long address, int value) {
        UNSAFE.putInt(address, value);
    }

    static void putLong(long address, long value) {
        UNSAFE.putLong(address, value);
    }

    static void putByte(byte[] data, int index, byte value) {
        UNSAFE.putByte(data, BYTE_ARRAY_BASE_OFFSET + (long)index, value);
    }

    static void putShort(byte[] data, int index, short value) {
        UNSAFE.putShort(data, BYTE_ARRAY_BASE_OFFSET + (long)index, value);
    }

    static void putInt(byte[] data, int index, int value) {
        UNSAFE.putInt(data, BYTE_ARRAY_BASE_OFFSET + (long)index, value);
    }

    static void putLong(byte[] data, int index, long value) {
        UNSAFE.putLong(data, BYTE_ARRAY_BASE_OFFSET + (long)index, value);
    }

    static void copyMemory(long srcAddr, long dstAddr, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(srcAddr, dstAddr, size);
            length -= size;
            srcAddr += size;
            dstAddr += size;
        }
    }

    static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, size);
            length -= size;
            srcOffset += size;
            dstOffset += size;
        }
    }

    static boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
        if (length == 0) {
            return true;
        }
        long baseOffset1 = BYTE_ARRAY_BASE_OFFSET + (long)startPos1;
        long baseOffset2 = BYTE_ARRAY_BASE_OFFSET + (long)startPos2;
        int remainingBytes = length & 7;
        long end = baseOffset1 + (long)remainingBytes;
        long i = baseOffset1 - 8L + (long)length;
        long j = baseOffset2 - 8L + (long)length;
        while (i >= end) {
            if (UNSAFE.getLong(bytes1, i) != UNSAFE.getLong(bytes2, j)) {
                return false;
            }
            i -= 8L;
            j -= 8L;
        }
        switch (remainingBytes) {
            case 7: {
                return UNSAFE.getInt(bytes1, baseOffset1 + 3L) == UNSAFE.getInt(bytes2, baseOffset2 + 3L) && UNSAFE.getChar(bytes1, baseOffset1 + 1L) == UNSAFE.getChar(bytes2, baseOffset2 + 1L) && UNSAFE.getByte(bytes1, baseOffset1) == UNSAFE.getByte(bytes2, baseOffset2);
            }
            case 6: {
                return UNSAFE.getInt(bytes1, baseOffset1 + 2L) == UNSAFE.getInt(bytes2, baseOffset2 + 2L) && UNSAFE.getChar(bytes1, baseOffset1) == UNSAFE.getChar(bytes2, baseOffset2);
            }
            case 5: {
                return UNSAFE.getInt(bytes1, baseOffset1 + 1L) == UNSAFE.getInt(bytes2, baseOffset2 + 1L) && UNSAFE.getByte(bytes1, baseOffset1) == UNSAFE.getByte(bytes2, baseOffset2);
            }
            case 4: {
                return UNSAFE.getInt(bytes1, baseOffset1) == UNSAFE.getInt(bytes2, baseOffset2);
            }
            case 3: {
                return UNSAFE.getChar(bytes1, baseOffset1 + 1L) == UNSAFE.getChar(bytes2, baseOffset2 + 1L) && UNSAFE.getByte(bytes1, baseOffset1) == UNSAFE.getByte(bytes2, baseOffset2);
            }
            case 2: {
                return UNSAFE.getChar(bytes1, baseOffset1) == UNSAFE.getChar(bytes2, baseOffset2);
            }
            case 1: {
                return UNSAFE.getByte(bytes1, baseOffset1) == UNSAFE.getByte(bytes2, baseOffset2);
            }
        }
        return true;
    }

    static int hashCodeAscii(byte[] bytes, int startPos, int length) {
        int hash = -1028477387;
        long baseOffset = BYTE_ARRAY_BASE_OFFSET + (long)startPos;
        int remainingBytes = length & 7;
        if (length > 7) {
            long end = baseOffset + (long)remainingBytes;
            for (long i = baseOffset - 8L + (long)length; i >= end; i -= 8L) {
                hash = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(bytes, i), hash);
            }
        }
        switch (remainingBytes) {
            case 7: {
                return ((hash * 31 + Integer.rotateLeft(PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(bytes, baseOffset + 3L)), 13)) * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(bytes, baseOffset + 1L))) * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(bytes, baseOffset));
            }
            case 6: {
                return (hash * 31 + Integer.rotateLeft(PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(bytes, baseOffset + 2L)), 13)) * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(bytes, baseOffset));
            }
            case 5: {
                return (hash * 31 + Integer.rotateLeft(PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(bytes, baseOffset + 1L)), 13)) * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(bytes, baseOffset));
            }
            case 4: {
                return hash * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(bytes, baseOffset));
            }
            case 3: {
                return (hash * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(bytes, baseOffset + 1L))) * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(bytes, baseOffset));
            }
            case 2: {
                return hash * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(bytes, baseOffset));
            }
            case 1: {
                return hash * 31 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(bytes, baseOffset));
            }
        }
        return hash;
    }

    static int hashCodeAscii(char[] bytes) {
        int hash = -1028477387;
        int remainingBytes = bytes.length & 7;
        for (int i = bytes.length - 8; i >= remainingBytes; i -= 8) {
            hash = PlatformDependent0.hashCodeAsciiComputeFromChar(UNSAFE.getLong(bytes, CHAR_ARRAY_BASE_OFFSET + (long)i * CHAR_ARRAY_INDEX_SCALE), UNSAFE.getLong(bytes, CHAR_ARRAY_BASE_OFFSET + (long)(i + 4) * CHAR_ARRAY_INDEX_SCALE), hash);
        }
        switch (remainingBytes) {
            case 7: {
                return ((hash * 31 + Integer.rotateLeft(PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getLong(bytes, CHAR_ARRAY_BASE_OFFSET + 3L * CHAR_ARRAY_INDEX_SCALE)), 13)) * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getInt(bytes, CHAR_ARRAY_BASE_OFFSET + CHAR_ARRAY_INDEX_SCALE))) * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getShort(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
            case 6: {
                return (hash * 31 + Integer.rotateLeft(PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getLong(bytes, CHAR_ARRAY_BASE_OFFSET + 2L * CHAR_ARRAY_INDEX_SCALE)), 13)) * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getInt(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
            case 5: {
                return (hash * 31 + Integer.rotateLeft(PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getLong(bytes, CHAR_ARRAY_BASE_OFFSET + CHAR_ARRAY_INDEX_SCALE)), 13)) * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getShort(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
            case 4: {
                return hash * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getLong(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
            case 3: {
                return (hash * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getInt(bytes, CHAR_ARRAY_BASE_OFFSET + CHAR_ARRAY_INDEX_SCALE))) * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getShort(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
            case 2: {
                return hash * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getInt(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
            case 1: {
                return hash * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(UNSAFE.getShort(bytes, CHAR_ARRAY_BASE_OFFSET));
            }
        }
        return hash;
    }

    static char[] array(CharSequence data) {
        return STRING_VALUE_FIELD_OFFSET != -1L && data.getClass() == String.class ? (char[])UNSAFE.getObject(data, STRING_VALUE_FIELD_OFFSET) : null;
    }

    static int hashCodeAsciiCompute(long value, int hash) {
        return (hash * 31 + (int)((value & 0x1F1F1F1F00000000L) >>> 32)) * 31 + PlatformDependent0.hashCodeAsciiSanitize((int)value);
    }

    static int hashCodeAsciiComputeFromChar(long high, long low, int hash) {
        return (hash * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(low)) * 31 + PlatformDependent0.hashCodeAsciiSanitizeFromChar(high);
    }

    static int hashCodeAsciiSanitize(int value) {
        return value & 0x1F1F1F1F;
    }

    private static int hashCodeAsciiSanitizeFromChar(long value) {
        return (int)((value & 0x1F000000000000L) >>> 24 | (value & 0x1F00000000L) >>> 16 | (value & 0x1F0000L) >>> 8 | value & 0x1FL);
    }

    static int hashCodeAsciiSanitize(short value) {
        return value & 0x1F1F;
    }

    private static int hashCodeAsciiSanitizeFromChar(int value) {
        return (value & 0x1F0000) >>> 8 | value & 0x1F;
    }

    static int hashCodeAsciiSanitizeAsByte(char value) {
        return value & 0x1F;
    }

    static int hashCodeAsciiSanitize(byte value) {
        return value & 0x1F;
    }

    private static int hashCodeAsciiSanitizeFromChar(short value) {
        return value & 0x1F;
    }

    static <U, W> AtomicReferenceFieldUpdater<U, W> newAtomicReferenceFieldUpdater(Class<? super U> tclass, String fieldName) throws Exception {
        return new UnsafeAtomicReferenceFieldUpdater(UNSAFE, tclass, fieldName);
    }

    static <T> AtomicIntegerFieldUpdater<T> newAtomicIntegerFieldUpdater(Class<? super T> tclass, String fieldName) throws Exception {
        return new UnsafeAtomicIntegerFieldUpdater<T>(UNSAFE, tclass, fieldName);
    }

    static <T> AtomicLongFieldUpdater<T> newAtomicLongFieldUpdater(Class<? super T> tclass, String fieldName) throws Exception {
        return new UnsafeAtomicLongFieldUpdater<T>(UNSAFE, tclass, fieldName);
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long size) {
        return UNSAFE.allocateMemory(size);
    }

    static void freeMemory(long address) {
        UNSAFE.freeMemory(address);
    }

    private PlatformDependent0() {
    }

    static {
        Unsafe unsafe;
        Field addressField;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            if (addressField.getLong(ByteBuffer.allocate(1)) != 0L) {
                addressField = null;
            } else if (addressField.getLong(direct) == 0L) {
                addressField = null;
            }
        }
        catch (Throwable t) {
            addressField = null;
        }
        logger.debug("java.nio.Buffer.address: {}", (Object)(addressField != null ? "available" : "unavailable"));
        if (addressField != null) {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafe = (Unsafe)unsafeField.get(null);
                logger.debug("sun.misc.Unsafe.theUnsafe: {}", (Object)(unsafe != null ? "available" : "unavailable"));
                try {
                    if (unsafe != null) {
                        unsafe.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                        logger.debug("sun.misc.Unsafe.copyMemory: available");
                    }
                }
                catch (NoSuchMethodError t) {
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable");
                    throw t;
                }
                catch (NoSuchMethodException e) {
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable");
                    throw e;
                }
            }
            catch (Throwable cause) {
                unsafe = null;
            }
        } else {
            unsafe = null;
        }
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            CHAR_ARRAY_INDEX_SCALE = -1L;
            CHAR_ARRAY_BASE_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            UNALIGNED = false;
            STRING_VALUE_FIELD_OFFSET = -1L;
        } else {
            boolean unaligned;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset(addressField);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            CHAR_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
            CHAR_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(char[].class);
            try {
                Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
                Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
                unalignedMethod.setAccessible(true);
                unaligned = Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
            }
            catch (Throwable t) {
                String arch = SystemPropertyUtil.get("os.arch", "");
                unaligned = arch.matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
            }
            UNALIGNED = unaligned;
            logger.debug("java.nio.Bits.unaligned: {}", (Object)UNALIGNED);
            Field stringValueField = null;
            try {
                stringValueField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                    @Override
                    public Field run() {
                        try {
                            Field f = String.class.getDeclaredField("value");
                            f.setAccessible(true);
                            return f;
                        }
                        catch (NoSuchFieldException e) {
                            logger.info("Failed to find String value array (please report an issue).String hash code optimizations are disabled.", e);
                        }
                        catch (SecurityException e) {
                            logger.debug("No permissions to get String value array.String hash code optimizations are disabled.", e);
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                logger.debug("AccessController.doPrivileged failed to get String value array.String hash code optimizations are disabled.", t);
            }
            STRING_VALUE_FIELD_OFFSET = stringValueField == null ? -1L : UNSAFE.objectFieldOffset(stringValueField);
        }
    }
}

