/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Settings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class Http2SettingsTest {
    private Http2Settings settings;

    @BeforeEach
    public void setup() {
        this.settings = new Http2Settings();
    }

    @Test
    public void standardSettingsShouldBeNotSet() {
        Assertions.assertEquals((int)0, (int)this.settings.size());
        Assertions.assertNull((Object)this.settings.headerTableSize());
        Assertions.assertNull((Object)this.settings.initialWindowSize());
        Assertions.assertNull((Object)this.settings.maxConcurrentStreams());
        Assertions.assertNull((Object)this.settings.pushEnabled());
        Assertions.assertNull((Object)this.settings.maxFrameSize());
        Assertions.assertNull((Object)this.settings.maxHeaderListSize());
    }

    @Test
    public void standardSettingsShouldBeSet() {
        this.settings.initialWindowSize(1);
        this.settings.maxConcurrentStreams(2L);
        this.settings.pushEnabled(true);
        this.settings.headerTableSize(3L);
        this.settings.maxFrameSize(0xFFFFFF);
        this.settings.maxHeaderListSize(4L);
        Assertions.assertEquals((int)1, (int)this.settings.initialWindowSize());
        Assertions.assertEquals((long)2L, (long)this.settings.maxConcurrentStreams());
        Assertions.assertTrue((boolean)this.settings.pushEnabled());
        Assertions.assertEquals((long)3L, (long)this.settings.headerTableSize());
        Assertions.assertEquals((int)0xFFFFFF, (int)this.settings.maxFrameSize());
        Assertions.assertEquals((long)4L, (long)this.settings.maxHeaderListSize());
    }

    @Test
    public void settingsShouldSupportUnsignedShort() {
        char key = '\u8000';
        this.settings.put(key, Long.valueOf(123L));
        Assertions.assertEquals((long)123L, (long)((Long)this.settings.get(key)));
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={0L, 1L, 0xFFFFFFFEL, 0xFFFFFFFFL})
    public void headerListSize(long value) {
        this.settings.maxHeaderListSize(value);
        Assertions.assertEquals((long)value, (long)this.settings.maxHeaderListSize());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, -1L, 0x100000000L, 0x7FFFFFFFFFFFFFFFL})
    public void headerListSizeBoundCheck(final long value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.maxHeaderListSize(value);
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={0L, 1L, 0xFFFFFFFEL, 0xFFFFFFFFL})
    public void headerTableSize(long value) {
        this.settings.headerTableSize(value);
        Assertions.assertEquals((long)value, (long)this.settings.headerTableSize());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, -1L, 0x100000000L, 0x7FFFFFFFFFFFFFFFL})
    public void headerTableSizeBoundCheck(final long value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.headerTableSize(value);
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(booleans={false, true})
    public void pushEnabled(boolean value) {
        this.settings.pushEnabled(value);
        Assertions.assertEquals((Object)value, (Object)this.settings.pushEnabled());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={0L, 1L})
    public void enablePush(long value) {
        this.settings.put('\u0002', Long.valueOf(value));
        Assertions.assertEquals((long)value, (long)((Long)this.settings.get('\u0002')));
        Assertions.assertEquals((Object)(value == 1L ? 1 : 0), (Object)this.settings.pushEnabled());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, -1L, 2L, 0x7FFFFFFFFFFFFFFFL})
    public void enablePushBoundCheck(final long value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.put('\u0002', Long.valueOf(value));
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={0L, 1L, 0xFFFFFFFEL, 0xFFFFFFFFL})
    public void maxConcurrentStreams(long value) {
        this.settings.maxConcurrentStreams(value);
        Assertions.assertEquals((long)value, (long)this.settings.maxConcurrentStreams());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, -1L, 0x100000000L, 0x7FFFFFFFFFFFFFFFL})
    public void maxConcurrentStreamsBoundCheck(final long value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.maxConcurrentStreams(value);
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(ints={0, 1, 0x7FFFFFFE, 0x7FFFFFFF})
    public void initialWindowSize(int value) {
        this.settings.initialWindowSize(value);
        Assertions.assertEquals((int)value, (int)this.settings.initialWindowSize());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(ints={-2147483648, -1})
    public void initialWindowSizeIntBoundCheck(final int value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.initialWindowSize(value);
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, -1L, 0x80000000L, 0x7FFFFFFFFFFFFFFFL})
    public void initialWindowSizeBoundCheck(final long value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.put('\u0004', Long.valueOf(value));
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(ints={16384, 16385, 0xFFFFFE, 0xFFFFFF})
    public void maxFrameSize(int value) {
        this.settings.maxFrameSize(value);
        Assertions.assertEquals((int)value, (int)this.settings.maxFrameSize());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(ints={-2147483648, 0, 16383, 0x1000000, 0x7FFFFFFF})
    public void maxFrameSizeIntBoundCheck(final int value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.maxFrameSize(value);
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, 0L, 16383L, 0x1000000L, 0x7FFFFFFFL, 0x7FFFFFFFFFFFFFFFL})
    public void maxFrameSizeBoundCheck(final long value) {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.put('\u0005', Long.valueOf(value));
            }
        });
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={0L, 1L, 123L, 0x7FFFFFFFL, 0xFFFFFFFEL, 0xFFFFFFFFL})
    public void nonStandardSetting(long value) {
        char key = '\u0000';
        this.settings.put(key, Long.valueOf(value));
        Assertions.assertEquals((long)value, (long)((Long)this.settings.get(key)));
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @ValueSource(longs={-9223372036854775808L, -2147483648L, -1L, 0x100000000L, 0x7FFFFFFFFFFFFFFFL})
    public void nonStandardSettingBoundCheck(final long value) {
        boolean key = false;
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                Http2SettingsTest.this.settings.put('\u0000', Long.valueOf(value));
            }
        });
    }
}

