/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Http2HeadersTest {
    @Test
    public void testGetPseudoHeader() {
        for (Http2Headers.PseudoHeaderName pseudoHeaderName : Http2Headers.PseudoHeaderName.values()) {
            Assertions.assertSame((Object)pseudoHeaderName, (Object)Http2Headers.PseudoHeaderName.getPseudoHeader((AsciiString)pseudoHeaderName.value()));
            Assertions.assertSame((Object)pseudoHeaderName, (Object)Http2Headers.PseudoHeaderName.getPseudoHeader((AsciiString)new AsciiString(pseudoHeaderName.value().array())));
            Assertions.assertSame((Object)pseudoHeaderName, (Object)Http2Headers.PseudoHeaderName.getPseudoHeader((CharSequence)pseudoHeaderName.value().toString()));
            Assertions.assertSame((Object)pseudoHeaderName, (Object)Http2Headers.PseudoHeaderName.getPseudoHeader((CharSequence)new String(pseudoHeaderName.value().toCharArray())));
            Assertions.assertSame((Object)pseudoHeaderName, (Object)Http2Headers.PseudoHeaderName.getPseudoHeader((CharSequence)new StringBuilder((CharSequence)pseudoHeaderName.value())));
        }
    }

    @Test
    public void pseudoHeaderNamesAreLiterals() {
        Assertions.assertSame((Object)":authority", (Object)Http2Headers.PseudoHeaderName.AUTHORITY.value().toString());
        Assertions.assertSame((Object)":method", (Object)Http2Headers.PseudoHeaderName.METHOD.value().toString());
        Assertions.assertSame((Object)":path", (Object)Http2Headers.PseudoHeaderName.PATH.value().toString());
        Assertions.assertSame((Object)":scheme", (Object)Http2Headers.PseudoHeaderName.SCHEME.value().toString());
        Assertions.assertSame((Object)":status", (Object)Http2Headers.PseudoHeaderName.STATUS.value().toString());
        Assertions.assertSame((Object)":protocol", (Object)Http2Headers.PseudoHeaderName.PROTOCOL.value().toString());
    }

    @Test
    public void testIsPseudoHeader() {
        for (Http2Headers.PseudoHeaderName pseudoHeaderName : Http2Headers.PseudoHeaderName.values()) {
            Assertions.assertTrue((boolean)Http2Headers.PseudoHeaderName.isPseudoHeader((AsciiString)pseudoHeaderName.value()));
            Assertions.assertTrue((boolean)Http2Headers.PseudoHeaderName.isPseudoHeader((AsciiString)new AsciiString(pseudoHeaderName.value().array())));
            Assertions.assertTrue((boolean)Http2Headers.PseudoHeaderName.isPseudoHeader((String)pseudoHeaderName.value().toString()));
            Assertions.assertTrue((boolean)Http2Headers.PseudoHeaderName.isPseudoHeader((String)new String(pseudoHeaderName.value().toCharArray())));
            Assertions.assertTrue((boolean)Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)new StringBuilder((CharSequence)pseudoHeaderName.value())));
        }
    }
}

