/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2EmptyDataFrameListener;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class Http2EmptyDataFrameListenerTest {
    @Mock
    private Http2FrameListener frameListener;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private ByteBuf nonEmpty;
    private Http2EmptyDataFrameListener listener;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.nonEmpty.isReadable()).thenReturn((Object)true);
        this.listener = new Http2EmptyDataFrameListener(this.frameListener, 2);
    }

    @Test
    public void testEmptyDataFrames() throws Http2Exception {
        this.listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        this.listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                Http2EmptyDataFrameListenerTest.this.listener.onDataRead(Http2EmptyDataFrameListenerTest.this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)2))).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void testEmptyDataFramesWithNonEmptyInBetween() throws Http2Exception {
        final Http2EmptyDataFrameListener listener = new Http2EmptyDataFrameListener(this.frameListener, 2);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onDataRead(this.ctx, 1, this.nonEmpty, 0, false);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                listener.onDataRead(Http2EmptyDataFrameListenerTest.this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)4))).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void testEmptyDataFramesWithEndOfStreamInBetween() throws Http2Exception {
        final Http2EmptyDataFrameListener listener = new Http2EmptyDataFrameListener(this.frameListener, 2);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, true);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                listener.onDataRead(Http2EmptyDataFrameListenerTest.this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)1))).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)3))).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void testEmptyDataFramesWithHeaderFrameInBetween() throws Http2Exception {
        final Http2EmptyDataFrameListener listener = new Http2EmptyDataFrameListener(this.frameListener, 2);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onHeadersRead(this.ctx, 1, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                listener.onDataRead(Http2EmptyDataFrameListenerTest.this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)1))).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)3))).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void testEmptyDataFramesWithHeaderFrameInBetween2() throws Http2Exception {
        final Http2EmptyDataFrameListener listener = new Http2EmptyDataFrameListener(this.frameListener, 2);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onHeadersRead(this.ctx, 1, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, (short)0, false, 0, true);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        listener.onDataRead(this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                listener.onDataRead(Http2EmptyDataFrameListenerTest.this.ctx, 1, Unpooled.EMPTY_BUFFER, 0, false);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)1))).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((short)0), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener, (VerificationMode)Mockito.times((int)3))).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }
}

