/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CleartextHttp2ServerUpgradeHandlerTest {
    private EmbeddedChannel channel;
    private Http2FrameListener frameListener;
    private Http2ConnectionHandler http2ConnectionHandler;
    private List<Object> userEvents;

    private void setUpServerChannel() {
        this.frameListener = (Http2FrameListener)Mockito.mock(Http2FrameListener.class);
        this.http2ConnectionHandler = new Http2ConnectionHandlerBuilder().frameListener(this.frameListener).build();
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new Http2ServerUpgradeCodec(CleartextHttp2ServerUpgradeHandlerTest.this.http2ConnectionHandler);
            }
        };
        this.userEvents = new ArrayList<Object>();
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, upgradeCodecFactory);
        CleartextHttp2ServerUpgradeHandler handler = new CleartextHttp2ServerUpgradeHandler(httpServerCodec, upgradeHandler, (ChannelHandler)this.http2ConnectionHandler);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                CleartextHttp2ServerUpgradeHandlerTest.this.userEvents.add(evt);
            }
        }});
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void priorKnowledge() throws Exception {
        this.setUpServerChannel();
        this.channel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        ByteBuf settingsFrame = CleartextHttp2ServerUpgradeHandlerTest.settingsFrameBuf();
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{settingsFrame}));
        Assertions.assertEquals((int)1, (int)this.userEvents.size());
        Assertions.assertTrue((boolean)(this.userEvents.get(0) instanceof CleartextHttp2ServerUpgradeHandler.PriorKnowledgeUpgradeEvent));
        Assertions.assertEquals((int)100, (int)this.http2ConnectionHandler.connection().local().maxActiveStreams());
        Assertions.assertEquals((int)65535, (int)((Http2LocalFlowController)this.http2ConnectionHandler.connection().local().flowController()).initialWindowSize());
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener)).onSettingsRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Http2Settings)Mockito.eq((Object)CleartextHttp2ServerUpgradeHandlerTest.expectedSettings()));
    }

    @Test
    public void upgrade() throws Exception {
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nConnection: Upgrade, HTTP2-Settings\r\nUpgrade: h2c\r\nHTTP2-Settings: AAMAAABkAAQAAP__\r\n\r\n";
        this.validateClearTextUpgrade(upgradeString);
    }

    @Test
    public void upgradeWithMultipleConnectionHeaders() {
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nConnection: keep-alive\r\nConnection: Upgrade, HTTP2-Settings\r\nUpgrade: h2c\r\nHTTP2-Settings: AAMAAABkAAQAAP__\r\n\r\n";
        this.validateClearTextUpgrade(upgradeString);
    }

    @Test
    public void requiredHeadersInSeparateConnectionHeaders() {
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nConnection: keep-alive\r\nConnection: HTTP2-Settings\r\nConnection: Upgrade\r\nUpgrade: h2c\r\nHTTP2-Settings: AAMAAABkAAQAAP__\r\n\r\n";
        this.validateClearTextUpgrade(upgradeString);
    }

    @Test
    public void priorKnowledgeInFragments() throws Exception {
        this.setUpServerChannel();
        ByteBuf connectionPreface = Http2CodecUtil.connectionPrefaceBuf();
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{connectionPreface.readBytes(5), connectionPreface}));
        ByteBuf settingsFrame = CleartextHttp2ServerUpgradeHandlerTest.settingsFrameBuf();
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{settingsFrame}));
        Assertions.assertEquals((int)1, (int)this.userEvents.size());
        Assertions.assertTrue((boolean)(this.userEvents.get(0) instanceof CleartextHttp2ServerUpgradeHandler.PriorKnowledgeUpgradeEvent));
        Assertions.assertEquals((int)100, (int)this.http2ConnectionHandler.connection().local().maxActiveStreams());
        Assertions.assertEquals((int)65535, (int)((Http2LocalFlowController)this.http2ConnectionHandler.connection().local().flowController()).initialWindowSize());
        ((Http2FrameListener)Mockito.verify((Object)this.frameListener)).onSettingsRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (Http2Settings)Mockito.eq((Object)CleartextHttp2ServerUpgradeHandlerTest.expectedSettings()));
    }

    @Test
    public void downgrade() throws Exception {
        this.setUpServerChannel();
        String requestString = "GET / HTTP/1.1\r\nHost: example.com\r\n\r\n";
        ByteBuf inbound = Unpooled.buffer().writeBytes(requestString.getBytes(CharsetUtil.US_ASCII));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{inbound}));
        Object firstInbound = this.channel.readInbound();
        Assertions.assertTrue((boolean)(firstInbound instanceof HttpRequest));
        HttpRequest request = (HttpRequest)firstInbound;
        Assertions.assertEquals((Object)HttpMethod.GET, (Object)request.method());
        Assertions.assertEquals((Object)"/", (Object)request.uri());
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.protocolVersion());
        Assertions.assertEquals((Object)new DefaultHttpHeaders().add("Host", (Object)"example.com"), (Object)request.headers());
        ((LastHttpContent)this.channel.readInbound()).release();
        Assertions.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void usedHttp2MultiplexCodec() throws Exception {
        final Http2MultiplexCodec http2Codec = new Http2MultiplexCodecBuilder(true, (ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
            }
        }).build();
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new Http2ServerUpgradeCodec(http2Codec);
            }
        };
        this.http2ConnectionHandler = http2Codec;
        this.userEvents = new ArrayList<Object>();
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, upgradeCodecFactory);
        CleartextHttp2ServerUpgradeHandler handler = new CleartextHttp2ServerUpgradeHandler(httpServerCodec, upgradeHandler, (ChannelHandler)http2Codec);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                CleartextHttp2ServerUpgradeHandlerTest.this.userEvents.add(evt);
            }
        }});
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()}));
        ByteBuf settingsFrame = CleartextHttp2ServerUpgradeHandlerTest.settingsFrameBuf();
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{settingsFrame}));
        Assertions.assertEquals((int)1, (int)this.userEvents.size());
        Assertions.assertTrue((boolean)(this.userEvents.get(0) instanceof CleartextHttp2ServerUpgradeHandler.PriorKnowledgeUpgradeEvent));
    }

    private static ByteBuf settingsFrameBuf() {
        ByteBuf settingsFrame = Unpooled.buffer();
        settingsFrame.writeMedium(12);
        settingsFrame.writeByte(4);
        settingsFrame.writeByte(0);
        settingsFrame.writeInt(0);
        settingsFrame.writeShort(3);
        settingsFrame.writeInt(100);
        settingsFrame.writeShort(4);
        settingsFrame.writeInt(65535);
        return settingsFrame;
    }

    private static Http2Settings expectedSettings() {
        return new Http2Settings().maxConcurrentStreams(100L).initialWindowSize(65535);
    }

    private void validateClearTextUpgrade(String upgradeString) {
        this.setUpServerChannel();
        ByteBuf upgrade = Unpooled.copiedBuffer((CharSequence)upgradeString, (Charset)CharsetUtil.US_ASCII);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{upgrade}));
        Assertions.assertEquals((int)1, (int)this.userEvents.size());
        Object userEvent = this.userEvents.get(0);
        Assertions.assertTrue((boolean)(userEvent instanceof HttpServerUpgradeHandler.UpgradeEvent));
        Assertions.assertEquals((Object)"h2c", (Object)((HttpServerUpgradeHandler.UpgradeEvent)userEvent).protocol());
        ReferenceCountUtil.release((Object)userEvent);
        Assertions.assertEquals((int)100, (int)this.http2ConnectionHandler.connection().local().maxActiveStreams());
        Assertions.assertEquals((int)65535, (int)((Http2LocalFlowController)this.http2ConnectionHandler.connection().local().flowController()).initialWindowSize());
        Assertions.assertEquals((int)1, (int)this.http2ConnectionHandler.connection().numActiveStreams());
        Assertions.assertNotNull((Object)this.http2ConnectionHandler.connection().stream(1));
        Http2Stream stream = this.http2ConnectionHandler.connection().stream(1);
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Assertions.assertFalse((boolean)stream.isHeadersSent());
        String expectedHttpResponse = "HTTP/1.1 101 Switching Protocols\r\nconnection: upgrade\r\nupgrade: h2c\r\n\r\n";
        ByteBuf responseBuffer = (ByteBuf)this.channel.readOutbound();
        Assertions.assertEquals((Object)expectedHttpResponse, (Object)responseBuffer.toString(CharsetUtil.UTF_8));
        responseBuffer.release();
        ByteBuf settingsBuffer = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)settingsBuffer);
        settingsBuffer.release();
        Assertions.assertNull((Object)this.channel.readOutbound());
    }
}

