/*
 * Decompiled with CFR 0.152.
 */
package io.netty.build.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.Filter;
import java.util.regex.Pattern;

public class SuppressionFilter
extends AutomaticBean
implements Filter {
    private static final Pattern JAVA5PATTERN = Pattern.compile("/org/jboss/");
    private Pattern pattern;
    private Pattern examplePattern = Pattern.compile("examples?");

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public void setExamplePattern(String pattern) {
        this.examplePattern = Pattern.compile(pattern);
    }

    public boolean accept(AuditEvent evt) {
        String filename = evt.getFileName().replace('\\', '/');
        if (JAVA5PATTERN.matcher(filename).find() && evt.getSourceName().endsWith("MissingOverrideCheck")) {
            return false;
        }
        if (this.pattern.matcher(filename).find()) {
            return false;
        }
        if (this.examplePattern.matcher(filename).find()) {
            if (evt.getSourceName().endsWith(".JavadocPackageCheck")) {
                return false;
            }
            if (evt.getSourceName().endsWith(".HideUtilityClassConstructorCheck")) {
                return false;
            }
        }
        return true;
    }

    protected void finishLocalSetup() {
    }
}

