/*
 * Decompiled with CFR 0.152.
 */
package io.netty.build.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.regex.Pattern;

public class NewlineCheck
extends AbstractFileSetCheck {
    private static final Pattern NON_CRLF = Pattern.compile("(?:[^\r]\n|\r[^\n])");
    private static final Pattern NON_LFCR = Pattern.compile("(?:[^\n]\r|\n[^\r])");
    private static final NewlineType NEWLINE_TYPE;

    protected void processFiltered(File file, FileText fileText) {
        String text = fileText.getFullText().toString();
        switch (NEWLINE_TYPE) {
            case LF: {
                if (text.indexOf(13) < 0) break;
                this.reportNewlineViolation();
                break;
            }
            case CR: {
                if (text.indexOf(10) < 0) break;
                this.reportNewlineViolation();
                break;
            }
            case CRLF: {
                if (!NON_CRLF.matcher(text).find()) break;
                this.reportNewlineViolation();
                break;
            }
            case LFCR: {
                if (!NON_LFCR.matcher(text).find()) break;
                this.reportNewlineViolation();
                break;
            }
            case RS: {
                if (text.indexOf(30) < 0) break;
                this.reportNewlineViolation();
            }
        }
    }

    private void reportNewlineViolation() {
        this.log(0, "invalid newline character (expected: " + (Object)((Object)NEWLINE_TYPE) + ')', new Object[0]);
    }

    static {
        String newline = System.lineSeparator();
        NEWLINE_TYPE = "\n".equals(newline) ? NewlineType.LF : ("\r".equals(newline) ? NewlineType.CR : ("\r\n".equals(newline) ? NewlineType.CRLF : ("\n\r".equals(newline) ? NewlineType.LFCR : ("\u001e".equals(newline) ? NewlineType.RS : NewlineType.UNKNOWN))));
    }

    private static enum NewlineType {
        UNKNOWN,
        CR,
        LF,
        CRLF,
        LFCR,
        RS;

    }
}

