/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v4.config;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.driver.mongodb.springdata.v4.SpringDataMongoV4Driver;
import io.mongock.driver.mongodb.springdata.v4.config.MongoDBConfiguration;
import io.mongock.driver.mongodb.springdata.v4.config.SpringDataMongoV4ContextBase;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.mongodb.core.MongoTemplate;

@AutoConfiguration
@ConditionalOnExpression(value="${mongock.enabled:true}")
@ConditionalOnBean(value={MongockConfiguration.class})
@EnableConfigurationProperties(value={MongoDBConfiguration.class})
public class SpringDataMongoV4Context
extends SpringDataMongoV4ContextBase<MongockConfiguration, SpringDataMongoV4Driver> {
    @Override
    protected SpringDataMongoV4Driver buildDriver(MongoTemplate mongoTemplate, MongockConfiguration config, MongoDBConfiguration mongoDbConfig) {
        return SpringDataMongoV4Driver.withLockStrategy(mongoTemplate, config.getLockAcquiredForMillis(), config.getLockQuitTryingAfterMillis(), config.getLockTryFrequencyMillis());
    }
}

