/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.testresources;

import io.micronaut.gradle.MicronautBasePlugin;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.testresources.ServerConnectionParametersProvider;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class MicronautTestResourcesConsumerPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.apply(MicronautBasePlugin.class);
        Configuration testResourcesConfiguration = this.createTestResourcesExtension(project);
        pluginManager.withPlugin("io.micronaut.component", unused -> project.afterEvaluate(p -> p.getConfigurations().all(cnf -> this.configureDependencies(testResourcesConfiguration, (Configuration)cnf))));
    }

    private Configuration createTestResourcesExtension(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration boms = (Configuration)configurations.findByName("micronautBoms");
        PluginsHelper.maybeAddMicronautPlaformBom((Project)project, (Configuration)boms);
        Configuration testResourcesConfiguration = (Configuration)project.getConfigurations().create("testResourcesService", conf -> {
            conf.extendsFrom(new Configuration[]{boms});
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
            conf.setDescription("Used to declare projects which provide test resources");
            conf.getDependencies().whenObjectAdded(dep -> {
                if (!(dep instanceof ProjectDependency)) {
                    throw new InvalidUserDataException("The test resources configuration can only contain project dependencies");
                }
                ProjectDependency projectDependency = (ProjectDependency)dep;
                projectDependency.attributes(attrs -> MicronautTestResourcesConsumerPlugin.configureUsageAttribute(project, attrs));
            });
        });
        Configuration testResourcesServerConfig = (Configuration)project.getConfigurations().create("internalTestResourcesServerConfig", conf -> {
            conf.extendsFrom(new Configuration[]{testResourcesConfiguration});
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
        });
        TaskProvider copyServerConfiguration = project.getTasks().register("copyTestResourceServerConfig", CopyServerConfiguration.class, t -> {
            t.getFiles().from(new Object[]{testResourcesServerConfig});
            t.getOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("test-resources-server-config"));
        });
        ServerConnectionParametersProvider jvmArgumentsConfiguration = MicronautTestResourcesConsumerPlugin.createJvmArgsProvider((TaskProvider<CopyServerConfiguration>)copyServerConfiguration);
        project.getTasks().withType(Test.class).configureEach(t -> t.getJvmArgumentProviders().add(jvmArgumentsConfiguration));
        project.getPlugins().withId("java-application", unused -> project.getTasks().named("run", JavaExec.class, t -> t.getJvmArgumentProviders().add(jvmArgumentsConfiguration)));
        return testResourcesConfiguration;
    }

    private static ServerConnectionParametersProvider createJvmArgsProvider(TaskProvider<CopyServerConfiguration> copyServerConfiguration) {
        return new ServerConnectionParametersProvider((Provider<Directory>)copyServerConfiguration.flatMap(CopyServerConfiguration::getOutputDirectory));
    }

    private static AttributeContainer configureUsageAttribute(Project project, AttributeContainer attrs) {
        return attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "micronaut.test.resources")));
    }

    private void configureDependencies(Configuration config, Configuration conf) {
        String name = conf.getName();
        if ("developmentOnly".equals(name) || "testRuntimeOnly".equals(name)) {
            conf.extendsFrom(new Configuration[]{config});
        }
    }

    public static abstract class CopyServerConfiguration
    extends DefaultTask {
        @InputFiles
        public abstract ConfigurableFileCollection getFiles();

        @OutputDirectory
        public abstract DirectoryProperty getOutputDirectory();

        @Inject
        public abstract FileSystemOperations getFileSystemOperations();

        @TaskAction
        public void copy() {
            this.getFileSystemOperations().copy(spec -> {
                spec.into((Object)this.getOutputDirectory());
                spec.from(new Object[]{this.getFiles()});
                spec.include(new String[]{"test-resources.properties"});
            });
        }
    }
}

