/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.openapi;

import io.micronaut.gradle.MicronautBasePlugin;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.openapi.DefaultOpenApiExtension;
import io.micronaut.gradle.openapi.OpenApiExtension;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class MicronautOpenAPIPlugin
implements Plugin<Project> {
    public static final String OPEN_API_GENERATOR_CONFIGURATION = "openApiGenerator";
    public static final String OPEN_API_GENERATOR_CLASSPATH_CONFIGURATION = "openApiGeneratorClasspath";

    public void apply(Project project) {
        project.getPluginManager().apply(MicronautBasePlugin.class);
        MicronautOpenAPIPlugin.createOpenAPIExtension(project);
    }

    private static void createOpenAPIExtension(Project project) {
        MicronautExtension micronautExtension = PluginsHelper.findMicronautExtension((Project)project);
        Configuration generatorDependencies = (Configuration)project.getConfigurations().create(OPEN_API_GENERATOR_CONFIGURATION, conf -> {
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(false);
            conf.setDescription("The OpenAPI Generator dependencies");
        });
        Configuration generatorClasspath = (Configuration)project.getConfigurations().create(OPEN_API_GENERATOR_CLASSPATH_CONFIGURATION, conf -> {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
            conf.setDescription("The OpenAPI Generator classpath");
            conf.extendsFrom(new Configuration[]{generatorDependencies});
        });
        OpenApiExtension openApiExtension = (OpenApiExtension)micronautExtension.getExtensions().create(OpenApiExtension.class, "openapi", DefaultOpenApiExtension.class, new Object[]{project, generatorClasspath});
        openApiExtension.getVersion().convention((Object)"6.15.0");
        generatorDependencies.getDependencies().addAllLater(openApiExtension.getVersion().map(version -> List.of(project.getDependencies().create((Object)("io.micronaut.openapi:micronaut-openapi-generator:" + version)))));
    }
}

