/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.openapi;

import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.openapi.OpenApiClientSpec;
import io.micronaut.gradle.openapi.OpenApiExtension;
import io.micronaut.gradle.openapi.OpenApiServerSpec;
import io.micronaut.gradle.openapi.OpenApiSpec;
import io.micronaut.gradle.openapi.tasks.AbstractOpenApiGenerator;
import io.micronaut.gradle.openapi.tasks.OpenApiClientGenerator;
import io.micronaut.gradle.openapi.tasks.OpenApiServerGenerator;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class DefaultOpenApiExtension
implements OpenApiExtension {
    public static final String OPENAPI_GROUP = "Micronaut OpenAPI";
    private static final String DEFAULT_SERIALIZATION_FRAMEWORK = "MICRONAUT_SERDE_JACKSON";
    private final Set<String> names = new HashSet<String>();
    private final Project project;
    private final Configuration classpath;

    @Inject
    public DefaultOpenApiExtension(Project project, Configuration classpath) {
        this.project = project;
        this.classpath = classpath;
    }

    @Override
    public void server(File file, Action<? super OpenApiServerSpec> spec) {
        RegularFileProperty regularFileProperty = this.project.getObjects().fileProperty();
        this.server("server", (Provider<RegularFile>)regularFileProperty.fileValue(file), spec);
    }

    @Override
    public void client(File file, Action<? super OpenApiClientSpec> spec) {
        RegularFileProperty regularFileProperty = this.project.getObjects().fileProperty();
        this.client("client", (Provider<RegularFile>)regularFileProperty.fileValue(file), spec);
    }

    @Override
    public void server(String name, Provider<RegularFile> definition, Action<? super OpenApiServerSpec> spec) {
        if (this.names.add(name)) {
            OpenApiServerSpec serverSpec = (OpenApiServerSpec)this.project.getObjects().newInstance(OpenApiServerSpec.class, new Object[0]);
            this.configureCommonExtensionDefaults(serverSpec);
            serverSpec.getControllerPackage().convention((Object)"io.micronaut.openapi.controller");
            serverSpec.getUseAuth().convention((Object)false);
            serverSpec.getAot().convention((Object)false);
            spec.execute((Object)serverSpec);
            TaskProvider controllers = this.project.getTasks().register(DefaultOpenApiExtension.generateApisTaskName(name), OpenApiServerGenerator.class, task -> {
                this.configureCommonProperties(name, (AbstractOpenApiGenerator<?, ?>)((Object)task), serverSpec, definition);
                task.getAot().set(serverSpec.getAot());
                task.setDescription("Generates OpenAPI controllers from an OpenAPI definition");
                DefaultOpenApiExtension.configureServerTask(serverSpec, task);
                task.getOutputKinds().addAll((Object[])new String[]{"apis", "supportingFiles"});
                task.setEnabled((Boolean)serverSpec.getGenerateApis().get());
            });
            TaskProvider models = this.project.getTasks().register(DefaultOpenApiExtension.generateModelsTaskName(name), OpenApiServerGenerator.class, task -> {
                this.configureCommonProperties(name, (AbstractOpenApiGenerator<?, ?>)((Object)task), serverSpec, definition);
                task.getAot().set(serverSpec.getAot());
                task.setDescription("Generates OpenAPI models from an OpenAPI definition");
                DefaultOpenApiExtension.configureServerTask(serverSpec, task);
                task.getOutputKinds().add((Object)"models");
                task.setEnabled((Boolean)serverSpec.getGenerateModels().get());
            });
            this.withJavaSourceSets(sourceSets -> {
                SourceDirectorySet javaMain = ((SourceSet)sourceSets.getByName("main")).getJava();
                javaMain.srcDir((Object)serverSpec.getGenerateApis().zip(controllers.flatMap(DefaultOpenApiExtension::mainSrcDir), this::ifEnabled));
                javaMain.srcDir((Object)serverSpec.getGenerateModels().zip(models.flatMap(DefaultOpenApiExtension::mainSrcDir), this::ifEnabled));
                this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.jvm", unused -> {
                    Object ext = ((SourceSet)sourceSets.getByName("main")).getExtensions().getByName("kotlin");
                    if (ext instanceof SourceDirectorySet) {
                        SourceDirectorySet kotlinMain = (SourceDirectorySet)ext;
                        kotlinMain.srcDir((Object)serverSpec.getGenerateApis().zip(controllers.flatMap(d -> DefaultOpenApiExtension.mainSrcDir(d, "kotlin")), this::ifEnabled));
                        kotlinMain.srcDir((Object)serverSpec.getGenerateModels().zip(models.flatMap(d -> DefaultOpenApiExtension.mainSrcDir(d, "kotlin")), this::ifEnabled));
                    }
                });
            });
        } else {
            DefaultOpenApiExtension.throwDuplicateEntryFor(name);
        }
    }

    private Directory ifEnabled(boolean enabled, Directory dir) {
        return enabled ? dir : this.project.getLayout().getProjectDirectory().dir("__ignore__");
    }

    private void configureCommonExtensionDefaults(OpenApiSpec spec) {
        spec.getApiPackageName().convention((Object)"io.micronaut.openapi.api");
        spec.getInvokerPackageName().convention((Object)"io.micronaut.openapi");
        spec.getModelPackageName().convention((Object)"io.micronaut.openapi.model");
        spec.getUseBeanValidation().convention((Object)true);
        spec.getUseOneOfInterfaces().convention((Object)true);
        spec.getUseOptional().convention((Object)false);
        spec.getUseReactive().convention((Object)true);
        spec.getLombok().convention((Object)false);
        spec.getKsp().convention((Object)false);
        spec.getGeneratedAnnotation().convention((Object)true);
        spec.getFluxForArrays().convention((Object)false);
        spec.getSerializationFramework().convention((Object)DEFAULT_SERIALIZATION_FRAMEWORK);
        spec.getAlwaysUseGenerateHttpResponse().convention((Object)false);
        spec.getGenerateHttpResponseWhereRequired().convention((Object)true);
        spec.getDateTimeFormat().convention((Object)"ZONED_DATETIME");
        spec.getLang().convention((Object)"java");
        spec.getGenerateSwaggerAnnotations().convention((Object)false);
        spec.getApiNamePrefix().convention((Object)"");
        spec.getApiNameSuffix().convention((Object)"");
        spec.getModelNamePrefix().convention((Object)"");
        spec.getModelNameSuffix().convention((Object)"");
        spec.getImplicitHeaders().convention((Object)false);
        spec.getImplicitHeadersRegex().convention((Object)"");
        spec.getUseEnumCaseInsensitive().convention((Object)false);
        spec.getUseJakartaEe().convention((Object)true);
        spec.getSortParamsByRequiredFlag().convention((Object)true);
        spec.getSkipOperationExample().convention((Object)false);
        spec.getSkipSortingOperations().convention((Object)false);
        spec.getRemoveOperationIdPrefixDelimiter().convention((Object)"_");
        spec.getRemoveOperationIdPrefixCount().convention((Object)1);
        spec.getSortModelPropertiesByRequiredFlag().convention((Object)true);
        spec.getEnsureUniqueParams().convention((Object)true);
        spec.getAllowUnicodeIdentifiers().convention((Object)false);
        spec.getPrependFormOrBodyParameters().convention((Object)false);
        spec.getGenerateApis().convention((Object)true);
        spec.getGenerateModels().convention((Object)true);
        spec.getCoroutines().convention((Object)false);
        spec.getUseSealed().convention((Object)false);
        spec.getJsonIncludeAlwaysForRequiredFields().convention((Object)false);
        spec.getRequiredPropertiesInConstructor().convention((Object)true);
        spec.getGenerateControllerAsAbstract().convention((Object)false);
        this.withJava(() -> {
            DependencySet compileOnlyDeps = this.project.getConfigurations().getByName("compileOnly").getDependencies();
            if ("java".equalsIgnoreCase((String)spec.getLang().get())) {
                compileOnlyDeps.addAllLater(spec.getLombok().map(lombok -> {
                    if (Boolean.TRUE.equals(lombok)) {
                        return List.of(this.project.getDependencies().create((Object)"org.projectlombok:lombok"));
                    }
                    return List.of();
                }));
            }
            compileOnlyDeps.add((Object)this.project.getDependencies().create((Object)"io.micronaut.openapi:micronaut-openapi"));
            DependencySet implDeps = this.project.getConfigurations().getByName("implementation").getDependencies();
            implDeps.addAllLater(spec.getUseReactive().map(reactive -> {
                if (Boolean.TRUE.equals(reactive)) {
                    return List.of(this.project.getDependencies().create((Object)"io.projectreactor:reactor-core"));
                }
                return List.of();
            }));
        });
    }

    private void configureCommonProperties(String name, AbstractOpenApiGenerator<?, ?> task, OpenApiSpec openApiSpec, Provider<RegularFile> definitionFile) {
        task.setGroup(OPENAPI_GROUP);
        task.getClasspath().from(new Object[]{this.classpath});
        task.getApiPackageName().convention(openApiSpec.getApiPackageName());
        task.getInvokerPackageName().convention(openApiSpec.getInvokerPackageName());
        task.getModelPackageName().convention(openApiSpec.getModelPackageName());
        task.getOutputDirectory().convention(this.project.getLayout().getBuildDirectory().dir("generated/openapi/" + task.getName()));
        task.getUseBeanValidation().convention(openApiSpec.getUseBeanValidation());
        task.getUseOneOfInterfaces().convention(openApiSpec.getUseOneOfInterfaces());
        task.getUseOptional().convention(openApiSpec.getUseOptional());
        task.getUseReactive().convention(openApiSpec.getUseReactive());
        task.getDefinitionFile().convention(definitionFile);
        task.getSerializationFramework().convention(openApiSpec.getSerializationFramework());
        task.getAlwaysUseGenerateHttpResponse().convention(openApiSpec.getAlwaysUseGenerateHttpResponse());
        task.getGenerateHttpResponseWhereRequired().convention(openApiSpec.getGenerateHttpResponseWhereRequired());
        task.getDateTimeFormat().convention(openApiSpec.getDateTimeFormat());
        task.getParameterMappings().convention(openApiSpec.getParameterMappings());
        task.getLang().convention(openApiSpec.getLang());
        task.getLombok().convention(openApiSpec.getLombok());
        task.getKsp().convention(openApiSpec.getKsp());
        task.getGeneratedAnnotation().convention(openApiSpec.getGeneratedAnnotation());
        task.getFluxForArrays().convention(openApiSpec.getFluxForArrays());
        task.getResponseBodyMappings().convention(openApiSpec.getResponseBodyMappings());
        task.getSchemaMapping().convention(openApiSpec.getSchemaMapping());
        task.getImportMapping().convention(openApiSpec.getImportMapping());
        task.getNameMapping().convention(openApiSpec.getNameMapping());
        task.getTypeMapping().convention(openApiSpec.getTypeMapping());
        task.getEnumNameMapping().convention(openApiSpec.getEnumNameMapping());
        task.getModelNameMapping().convention(openApiSpec.getModelNameMapping());
        task.getInlineSchemaNameMapping().convention(openApiSpec.getInlineSchemaNameMapping());
        task.getInlineSchemaOption().convention(openApiSpec.getInlineSchemaOption());
        task.getOpenapiNormalizer().convention(openApiSpec.getOpenapiNormalizer());
        task.getApiNamePrefix().convention(openApiSpec.getApiNamePrefix());
        task.getApiNameSuffix().convention(openApiSpec.getApiNameSuffix());
        task.getModelNamePrefix().convention(openApiSpec.getModelNamePrefix());
        task.getModelNameSuffix().convention(openApiSpec.getModelNameSuffix());
        task.getUseEnumCaseInsensitive().convention(openApiSpec.getUseEnumCaseInsensitive());
        task.getGenerateSwaggerAnnotations().convention(openApiSpec.getGenerateSwaggerAnnotations());
        task.getImplicitHeaders().convention(openApiSpec.getImplicitHeaders());
        task.getImplicitHeadersRegex().convention(openApiSpec.getImplicitHeadersRegex());
        task.getAdditionalEnumTypeAnnotations().convention(openApiSpec.getAdditionalEnumTypeAnnotations());
        task.getAdditionalModelTypeAnnotations().convention(openApiSpec.getAdditionalModelTypeAnnotations());
        task.getAdditionalOneOfTypeAnnotations().convention(openApiSpec.getAdditionalOneOfTypeAnnotations());
        task.getAdditionalProperties().convention(openApiSpec.getAdditionalProperties());
        task.getUseJakartaEe().convention(openApiSpec.getUseJakartaEe());
        task.getSortParamsByRequiredFlag().convention(openApiSpec.getSortParamsByRequiredFlag());
        task.getSkipOperationExample().convention(openApiSpec.getSkipOperationExample());
        task.getSkipSortingOperations().convention(openApiSpec.getSkipSortingOperations());
        task.getRemoveOperationIdPrefixDelimiter().convention(openApiSpec.getRemoveOperationIdPrefixDelimiter());
        task.getRemoveOperationIdPrefixCount().convention(openApiSpec.getRemoveOperationIdPrefixCount());
        task.getSortModelPropertiesByRequiredFlag().convention(openApiSpec.getSortModelPropertiesByRequiredFlag());
        task.getEnsureUniqueParams().convention(openApiSpec.getEnsureUniqueParams());
        task.getAllowUnicodeIdentifiers().convention(openApiSpec.getAllowUnicodeIdentifiers());
        task.getPrependFormOrBodyParameters().convention(openApiSpec.getPrependFormOrBodyParameters());
        task.getCoroutines().convention(openApiSpec.getCoroutines());
        task.getUseSealed().convention(openApiSpec.getUseSealed());
        task.getJsonIncludeAlwaysForRequiredFields().convention(openApiSpec.getJsonIncludeAlwaysForRequiredFields());
        task.getRequiredPropertiesInConstructor().convention(openApiSpec.getRequiredPropertiesInConstructor());
        task.getGenerateControllerAsAbstract().convention(openApiSpec.getGenerateControllerAsAbstract());
    }

    private void withJavaSourceSets(Consumer<? super SourceSetContainer> consumer) {
        this.project.getPlugins().withId("java", unused -> consumer.accept(PluginsHelper.findSourceSets((Project)this.project)));
    }

    private void withJava(Runnable runnable) {
        this.project.getPlugins().withId("java", unused -> runnable.run());
    }

    @Override
    public void client(String name, Provider<RegularFile> definition, Action<? super OpenApiClientSpec> spec) {
        if (this.names.add(name)) {
            OpenApiClientSpec clientSpec = (OpenApiClientSpec)this.project.getObjects().newInstance(OpenApiClientSpec.class, new Object[0]);
            this.configureCommonExtensionDefaults(clientSpec);
            clientSpec.getUseAuth().convention((Object)false);
            spec.execute((Object)clientSpec);
            TaskProvider client = this.project.getTasks().register(DefaultOpenApiExtension.generateApisTaskName(name), OpenApiClientGenerator.class, task -> {
                this.configureCommonProperties(name, (AbstractOpenApiGenerator<?, ?>)((Object)task), clientSpec, definition);
                task.setDescription("Generates OpenAPI client from an OpenAPI definition");
                DefaultOpenApiExtension.configureClientTask(clientSpec, task);
                task.getOutputKinds().addAll((Object[])new String[]{"apis", "supportingFiles"});
                task.setEnabled((Boolean)clientSpec.getGenerateApis().get());
            });
            TaskProvider models = this.project.getTasks().register(DefaultOpenApiExtension.generateModelsTaskName(name), OpenApiClientGenerator.class, task -> {
                this.configureCommonProperties(name, (AbstractOpenApiGenerator<?, ?>)((Object)task), clientSpec, definition);
                task.setDescription("Generates OpenAPI client models from an OpenAPI definition");
                DefaultOpenApiExtension.configureClientTask(clientSpec, task);
                task.getOutputKinds().add((Object)"models");
                task.setEnabled((Boolean)clientSpec.getGenerateModels().get());
            });
            this.withJavaSourceSets(sourceSets -> {
                SourceDirectorySet javaMain = ((SourceSet)sourceSets.getByName("main")).getJava();
                javaMain.srcDir((Object)clientSpec.getGenerateApis().zip(client.flatMap(DefaultOpenApiExtension::mainSrcDir), this::ifEnabled));
                javaMain.srcDir((Object)clientSpec.getGenerateModels().zip(models.flatMap(DefaultOpenApiExtension::mainSrcDir), this::ifEnabled));
                this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.jvm", unused -> {
                    Object ext = ((SourceSet)sourceSets.getByName("main")).getExtensions().getByName("kotlin");
                    if (ext instanceof SourceDirectorySet) {
                        SourceDirectorySet kotlinMain = (SourceDirectorySet)ext;
                        kotlinMain.srcDir((Object)clientSpec.getGenerateApis().zip(client.flatMap(d -> DefaultOpenApiExtension.mainSrcDir(d, "kotlin")), this::ifEnabled));
                        kotlinMain.srcDir((Object)clientSpec.getGenerateModels().zip(models.flatMap(d -> DefaultOpenApiExtension.mainSrcDir(d, "kotlin")), this::ifEnabled));
                    }
                });
            });
            this.withJava(() -> {
                DependencySet implDeps = this.project.getConfigurations().getByName("implementation").getDependencies();
                implDeps.add((Object)this.project.getDependencies().create((Object)"io.micronaut:micronaut-http-client-core"));
                implDeps.add((Object)this.project.getDependencies().create((Object)"io.micronaut.validation:micronaut-validation"));
                DependencySet annProcessor = this.project.getConfigurations().getByName("annotationProcessor").getDependencies();
                annProcessor.add((Object)this.project.getDependencies().create((Object)"io.micronaut.validation:micronaut-validation-processor"));
            });
        } else {
            DefaultOpenApiExtension.throwDuplicateEntryFor(name);
        }
    }

    @Override
    public void server(String name, File definition, Action<? super OpenApiServerSpec> spec) {
        this.server(name, (Provider<RegularFile>)this.project.getObjects().fileProperty().fileValue(definition), spec);
    }

    @Override
    public void client(String name, File definition, Action<? super OpenApiClientSpec> spec) {
        this.client(name, (Provider<RegularFile>)this.project.getObjects().fileProperty().fileValue(definition), spec);
    }

    private static Provider<Directory> mainSrcDir(AbstractOpenApiGenerator<?, ?> t, String language) {
        return t.getOutputDirectory().dir("src/main/" + language);
    }

    private static Provider<Directory> mainSrcDir(AbstractOpenApiGenerator<?, ?> t) {
        return DefaultOpenApiExtension.mainSrcDir(t, "java");
    }

    private static void configureClientTask(OpenApiClientSpec clientSpec, OpenApiClientGenerator task) {
        task.getClientId().convention(clientSpec.getClientId());
        task.getClientPath().convention(clientSpec.getClientPath());
        task.getAdditionalClientTypeAnnotations().set(clientSpec.getAdditionalClientTypeAnnotations());
        task.getBasePathSeparator().convention(clientSpec.getBasePathSeparator());
        task.getAuthorizationFilterPattern().convention(clientSpec.getAuthorizationFilterPattern());
        task.getUseAuth().convention(clientSpec.getUseAuth());
    }

    private static void throwDuplicateEntryFor(String name) {
        throw new GradleException("An OpenAPI definition with name '" + name + "' was already created");
    }

    private static String generateModelsTaskName(String name) {
        return "generate" + StringGroovyMethods.capitalize((CharSequence)name) + "OpenApiModels";
    }

    private static String generateApisTaskName(String name) {
        return "generate" + StringGroovyMethods.capitalize((CharSequence)name) + "OpenApiApis";
    }

    private static void configureServerTask(OpenApiServerSpec serverSpec, OpenApiServerGenerator task) {
        task.getControllerPackage().convention(serverSpec.getControllerPackage());
        task.getUseAuth().convention(serverSpec.getUseAuth());
        task.getAot().convention(serverSpec.getAot());
    }
}

