/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowPluginSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShadowPluginSupport.class);
    public static final String OLD_SHADOW_PLUGIN = "com.github.johnrengelman.shadow";
    public static final String SHADOW_PLUGIN = "com.gradleup.shadow";

    private ShadowPluginSupport() {
    }

    public static void withShadowPlugin(Project p, Runnable action) {
        AtomicBoolean applied = new AtomicBoolean(false);
        AtomicBoolean hasNew = new AtomicBoolean(false);
        p.getPluginManager().withPlugin(OLD_SHADOW_PLUGIN, unused -> {
            p.afterEvaluate(project -> {
                if (!hasNew.get()) {
                    LOGGER.warn("The legacy Shadow plugin (id '{}') is deprecated. Please use the Gradle Shadow plugin instead (id = '{}')", (Object)OLD_SHADOW_PLUGIN, (Object)SHADOW_PLUGIN);
                }
            });
            applied.set(true);
            action.run();
        });
        p.getPluginManager().withPlugin(SHADOW_PLUGIN, unused -> {
            hasNew.set(true);
            if (applied.get()) {
                return;
            }
            action.run();
        });
    }

    public static void mergeServiceFiles(Project project) {
        project.getTasks().withType(ShadowJar.class).configureEach(ShadowJar::mergeServiceFiles);
    }
}

