/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.AttributeUtils;
import io.micronaut.gradle.MicronautComponentPlugin;
import io.micronaut.gradle.MicronautRuntime;
import io.micronaut.gradle.MicronautRuntimeDependencies;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.ShadowPluginSupport;
import io.micronaut.gradle.graalvm.GraalUtil;
import io.micronaut.gradle.internal.AutomaticDependency;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;

public class MicronautMinimalApplicationPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_DEVELOPMENT_ONLY = "developmentOnly";
    public static final String INTERNAL_CONTINUOUS_FLAG = "io.micronaut.internal.gradle.continuous";
    private static final Map<String, String> LOGGER_CONFIG_FILE_TO_DEPENDENCY = Map.of("logback.xml", "ch.qos.logback:logback-classic", "simplelogger.properties", "org.slf4j:slf4j-simple");

    public void apply(Project project) {
        PluginManager plugins = project.getPluginManager();
        plugins.apply(ApplicationPlugin.class);
        plugins.apply(MicronautComponentPlugin.class);
        PluginsHelper.registerVersionExtensions(MicronautRuntimeDependencies.KNOWN_VERSION_PROPERTIES, project);
        Configuration developmentOnly = this.createDevelopmentOnlyConfiguration(project);
        this.configureLogging(project);
        this.configureMicronautRuntime(project);
        this.configureJavaExecTasks(project, developmentOnly);
    }

    private void configureJavaExecTasks(Project project, Configuration developmentOnlyConfiguration) {
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration developmentRuntimeClasspath = (Configuration)configurations.create("developmentRuntimeClasspath", conf -> {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(true);
            Configuration runtimeClasspath = configurations.getByName("runtimeClasspath");
            conf.extendsFrom(new Configuration[]{runtimeClasspath});
            conf.extendsFrom(new Configuration[]{developmentOnlyConfiguration});
            AttributeUtils.copyAttributes(project.getProviders(), runtimeClasspath, conf);
        });
        tasks.withType(JavaExec.class).configureEach(javaExec -> {
            SourceSet sourceSet;
            SourceSetContainer sourceSets = PluginsHelper.findSourceSets(project);
            if (javaExec.getName().equals("run")) {
                javaExec.dependsOn(new Object[]{tasks.named("inspectRuntimeClasspath")});
                javaExec.jvmArgs(new Object[]{"-Dcom.sun.management.jmxremote"});
                if (!GraalUtil.isGraalJVM()) {
                    javaExec.jvmArgs(new Object[]{"-XX:TieredStopAtLevel=1"});
                }
                javaExec.getOutputs().upToDateWhen(t -> false);
                FileCollection classpath = javaExec.getClasspath();
                if (classpath instanceof ConfigurableFileCollection) {
                    ConfigurableFileCollection cp = (ConfigurableFileCollection)classpath;
                    Set from = cp.getFrom();
                    from.clear();
                    cp.from(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput()});
                    cp.from(new Object[]{developmentRuntimeClasspath});
                }
            }
            if ((project.getGradle().getStartParameter().isContinuous() || Boolean.getBoolean(INTERNAL_CONTINUOUS_FLAG)) && (sourceSet = (SourceSet)sourceSets.findByName("main")) != null) {
                LinkedHashMap<String, Boolean> sysProps = new LinkedHashMap<String, Boolean>();
                sysProps.put("micronaut.io.watch.restart", true);
                sysProps.put("micronaut.io.watch.enabled", true);
                final FileCollection sourceDirectories = sourceSet.getAllSource().getSourceDirectories();
                javaExec.doFirst((Action)new Action<Task>(){

                    public void execute(Task workaroundEagerSystemProps) {
                        String watchPaths = sourceDirectories.getFiles().stream().map(File::getPath).collect(Collectors.joining(","));
                        javaExec.systemProperty("micronaut.io.watch.paths", (Object)watchPaths);
                    }
                });
                javaExec.systemProperties(sysProps);
            }
        });
    }

    private Configuration createDevelopmentOnlyConfiguration(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration developmentOnly = (Configuration)configurations.create(CONFIGURATION_DEVELOPMENT_ONLY, conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
            conf.extendsFrom(new Configuration[]{configurations.getByName("micronautBoms")});
        });
        if (Os.isFamily((String)"mac")) {
            developmentOnly.getDependencies().add((Object)project.getDependencies().create((Object)"io.micronaut:micronaut-runtime-osx"));
        }
        return developmentOnly;
    }

    private void configureLogging(Project p) {
        DependencyHandler dependencyHandler = p.getDependencies();
        SourceSetContainer sourceSets = PluginsHelper.findSourceSets(p);
        SourceSet sourceSet = (SourceSet)sourceSets.findByName("main");
        if (sourceSet != null) {
            SourceDirectorySet resources = sourceSet.getResources();
            Set srcDirs = resources.getSrcDirs();
            block0: for (File srcDir : srcDirs) {
                for (Map.Entry<String, String> entry : LOGGER_CONFIG_FILE_TO_DEPENDENCY.entrySet()) {
                    File loggerConfigFile = new File(srcDir, entry.getKey());
                    if (!loggerConfigFile.exists()) continue;
                    dependencyHandler.add(sourceSet.getRuntimeOnlyConfigurationName(), (Object)entry.getValue());
                    break block0;
                }
            }
        }
    }

    private void configureMicronautRuntime(Project project) {
        project.afterEvaluate(p -> {
            MicronautRuntime micronautRuntime = PluginsHelper.resolveRuntime(p);
            DependencyHandler dependencyHandler = p.getDependencies();
            MicronautRuntimeDependencies.findApplicationPluginDependenciesByRuntime(micronautRuntime).toMap().forEach((scope, dependencies) -> {
                for (AutomaticDependency dependency : dependencies) {
                    dependency.applyTo(project);
                }
            });
            if (micronautRuntime == MicronautRuntime.GOOGLE_FUNCTION) {
                this.configureGoogleCloudFunctionRuntime(project, (Project)p, dependencyHandler);
            }
            ShadowPluginSupport.withShadowPlugin(project, () -> ShadowPluginSupport.mergeServiceFiles(project));
        });
    }

    private void configureGoogleCloudFunctionRuntime(Project project, Project p, DependencyHandler dependencyHandler) {
        String invokerConfig = "invoker";
        Configuration ic = (Configuration)project.getConfigurations().create(invokerConfig);
        dependencyHandler.add(invokerConfig, (Object)"com.google.cloud.functions.invoker:java-function-invoker:1.0.0-beta2");
        TaskContainer taskContainer = project.getTasks();
        taskContainer.register("runFunction", JavaExec.class, run -> {
            run.dependsOn(new Object[]{taskContainer.findByName("processResources"), taskContainer.findByName("classes")});
            run.getMainClass().set((Object)"com.google.cloud.functions.invoker.runner.Invoker");
            run.setClasspath((FileCollection)ic);
            run.setArgs(List.of("--target", "io.micronaut.gcp.function.http.HttpFunction", "--port", Integer.valueOf(8080)));
            SourceSet sourceSet = (SourceSet)PluginsHelper.findSourceSets(p).getByName("main");
            SourceSetOutput output = sourceSet.getOutput();
            String runtimeClasspath = project.files(new Object[]{project.getConfigurations().getByName("runtimeClasspath"), output}).getAsPath();
            run.doFirst(t -> ((JavaExec)t).args(new Object[]{"--classpath", runtimeClasspath}));
        });
        p.getPluginManager().apply("com.gradleup.shadow");
    }
}

