/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import com.google.devtools.ksp.gradle.KspExtension;
import io.micronaut.gradle.AnnotationProcessing;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.SourceSetConfigurerRegistry;
import io.micronaut.gradle.Strings;
import io.micronaut.gradle.internal.AutomaticDependency;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.kotlin.allopen.gradle.AllOpenExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinCompile;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;

public class MicronautKotlinSupport {
    private static final String[] KAPT_CONFIGURATIONS = new String[]{"kapt", "kaptTest"};
    private static final String[] KSP_CONFIGURATIONS = new String[]{"ksp", "kspTest"};
    public static final String KOTLIN_PROCESSORS = "kotlinProcessors";
    private static final List<String> KSP_ANNOTATION_PROCESSOR_MODULES = List.of("inject-kotlin");

    public static void whenKotlinSupportPresent(Project p, Consumer<? super Project> action) {
        p.getPluginManager().withPlugin("org.jetbrains.kotlin.jvm", unused -> action.accept(p));
    }

    public static boolean isKotlinAllOpenSupportPresent() {
        try {
            return AllOpenExtension.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void configureKotlin(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        TaskContainer tasks = project.getTasks();
        project.getConfigurations().create(KOTLIN_PROCESSORS, conf -> {
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(false);
        });
        tasks.withType(KotlinCompile.class).configureEach(kotlinCompile -> {
            KotlinJvmOptions kotlinOptions = (KotlinJvmOptions)kotlinCompile.getKotlinOptions();
            kotlinOptions.setJavaParameters(true);
        });
        pluginManager.withPlugin("org.jetbrains.kotlin.plugin.allopen", unused -> MicronautKotlinSupport.configureAllOpen(project));
        pluginManager.withPlugin("org.jetbrains.kotlin.kapt", unused -> MicronautKotlinSupport.configureKapt(project));
        pluginManager.withPlugin("com.google.devtools.ksp", unused -> MicronautKotlinSupport.configureKsp(project));
    }

    private static void configureKsp(Project project) {
        MicronautKotlinSupport.configureKotlinCompilerPlugin(project, KSP_CONFIGURATIONS, "ksp", KSP_ANNOTATION_PROCESSOR_MODULES);
        ExtensionContainer extensions = project.getExtensions();
        extensions.configure(KspExtension.class, kspExtension -> {
            MicronautExtension micronautExtension = (MicronautExtension)extensions.getByType(MicronautExtension.class);
            AnnotationProcessing processingConfig = micronautExtension.getProcessing();
            boolean isIncremental = (Boolean)processingConfig.getIncremental().getOrElse((Object)true);
            String group = (String)processingConfig.getGroup().getOrElse((Object)project.getGroup().toString());
            String module = (String)processingConfig.getModule().getOrElse((Object)project.getName());
            if (isIncremental) {
                kspExtension.arg("micronaut.processing.incremental", "true");
                if (!group.isEmpty()) {
                    kspExtension.arg("micronaut.processing.group", group);
                }
                kspExtension.arg("micronaut.processing.module", module);
            }
        });
    }

    private static void configureKapt(Project project) {
        MicronautKotlinSupport.configureKotlinCompilerPlugin(project, KAPT_CONFIGURATIONS, "kapt", PluginsHelper.ANNOTATION_PROCESSOR_MODULES);
        ExtensionContainer extensions = project.getExtensions();
        extensions.configure(KaptExtension.class, kaptExtension -> {
            kaptExtension.setGenerateStubs(false);
            MicronautExtension micronautExtension = (MicronautExtension)extensions.getByType(MicronautExtension.class);
            AnnotationProcessing processingConfig = micronautExtension.getProcessing();
            boolean isIncremental = (Boolean)processingConfig.getIncremental().getOrElse((Object)true);
            String group = (String)processingConfig.getGroup().getOrElse((Object)project.getGroup().toString());
            String module = (String)processingConfig.getModule().getOrElse((Object)project.getName());
            if (isIncremental) {
                kaptExtension.arguments(options -> {
                    options.arg((Object)"micronaut.processing.incremental", new Object[]{true});
                    List annotations = (List)processingConfig.getAnnotations().getOrElse(Collections.emptyList());
                    if (!annotations.isEmpty()) {
                        options.arg((Object)"micronaut.processing.annotations", new Object[]{String.join((CharSequence)",", annotations)});
                    } else if (!group.isEmpty()) {
                        options.arg((Object)"micronaut.processing.annotations", new Object[]{group + ".*"});
                    }
                    if (!group.isEmpty()) {
                        options.arg((Object)"micronaut.processing.group", new Object[]{group});
                    }
                    options.arg((Object)"micronaut.processing.module", new Object[]{module});
                    return null;
                });
            }
        });
    }

    private static void configureKotlinCompilerPlugin(Project project, String[] compilerConfigurations, String compilerType, List<String> annotationProcessorModules) {
        PluginsHelper.registerAnnotationProcessors(project, annotationProcessorModules, compilerConfigurations);
        MicronautKotlinSupport.addGraalVmDependencies(compilerConfigurations, project);
        Configuration kotlinProcessors = project.getConfigurations().getByName(KOTLIN_PROCESSORS);
        for (String compilerConfiguration : compilerConfigurations) {
            project.getConfigurations().getByName(compilerConfiguration).extendsFrom(new Configuration[]{kotlinProcessors});
        }
        PluginsHelper.applyAdditionalProcessors(project, compilerConfigurations);
        SourceSetConfigurerRegistry registry = (SourceSetConfigurerRegistry)project.getExtensions().getByType(SourceSetConfigurerRegistry.class);
        DependencyHandler dependencyHandler = project.getDependencies();
        Provider platform = PluginsHelper.findMicronautVersion(project).map(micronautVersion -> PluginsHelper.resolveMicronautPlatform(dependencyHandler, micronautVersion));
        HashSet knownSourceSets = new HashSet();
        registry.register(sourceSet -> {
            MicronautKotlinSupport.configureAdditionalSourceSet(compilerType, project, dependencyHandler, (Provider<Dependency>)platform, sourceSet);
            knownSourceSets.add(sourceSet);
        });
        for (String compileConfiguration : compilerConfigurations) {
            dependencyHandler.addProvider(compileConfiguration, platform);
        }
        project.afterEvaluate(p -> {
            PluginsHelper.applyAdditionalProcessors(p, compilerConfigurations);
            MicronautKotlinSupport.configureExtraSourceSetsUsingDeprecatedBehavior(compilerType, p, knownSourceSets, dependencyHandler, (Provider<Dependency>)platform);
        });
    }

    private static void configureExtraSourceSetsUsingDeprecatedBehavior(String compilerType, Project p, HashSet<SourceSet> knownSourceSets, DependencyHandler dependencyHandler, Provider<Dependency> platform) {
        List configurations;
        MicronautExtension micronautExtension = (MicronautExtension)p.getExtensions().getByType(MicronautExtension.class);
        ListProperty<SourceSet> additionalSourceSets = micronautExtension.getProcessing().getAdditionalSourceSets();
        if (additionalSourceSets.isPresent() && !(configurations = (List)additionalSourceSets.get()).isEmpty()) {
            for (SourceSet sourceSet : configurations) {
                if (knownSourceSets.contains(sourceSet)) continue;
                AnnotationProcessing.showAdditionalSourceSetDeprecationWarning(sourceSet);
                MicronautKotlinSupport.configureAdditionalSourceSet(compilerType, p, dependencyHandler, platform, sourceSet);
            }
        }
    }

    private static void configureAdditionalSourceSet(String compilerType, Project p, DependencyHandler dependencyHandler, Provider<Dependency> platform, SourceSet sourceSet) {
        String annotationProcessorConfigurationName = compilerType + Strings.capitalize(sourceSet.getName());
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        List<CallSite> both = List.of(implementationConfigurationName, annotationProcessorConfigurationName);
        for (String string : both) {
            dependencyHandler.addProvider(string, platform);
        }
        PluginsHelper.configureAnnotationProcessors(p, implementationConfigurationName, annotationProcessorConfigurationName);
        p.getPluginManager().withPlugin("io.micronaut.graalvm", unused -> new AutomaticDependency(annotationProcessorConfigurationName, "io.micronaut:micronaut-graal", Optional.of(PluginsHelper.CORE_VERSION_PROPERTY)).applyTo(p));
    }

    private static void addGraalVmDependencies(String[] compilerConfigurations, Project project) {
        project.getPluginManager().withPlugin("io.micronaut.graalvm", unused -> {
            for (String configuration : compilerConfigurations) {
                new AutomaticDependency(configuration, "io.micronaut:micronaut-graal", Optional.of(PluginsHelper.CORE_VERSION_PROPERTY)).applyTo(project);
            }
        });
    }

    private static void configureAllOpen(Project project) {
        AllOpenExtension allOpen = (AllOpenExtension)project.getExtensions().getByType(AllOpenExtension.class);
        allOpen.annotation("io.micronaut.aop.Around");
    }
}

