/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.AnnotationProcessing;
import io.micronaut.gradle.MicronautRuntime;
import io.micronaut.gradle.MicronautTestRuntime;
import io.micronaut.gradle.SourceSetConfigurer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;

public abstract class MicronautExtension
implements ExtensionAware {
    private final AnnotationProcessing processing;
    private final Property<String> version;
    private final Property<Boolean> enableNativeImage;
    private final Property<MicronautRuntime> runtime;
    private final Property<MicronautTestRuntime> testRuntime;

    public abstract Property<Boolean> getImportMicronautPlatform();

    public abstract SetProperty<String> getIgnoredAutomaticDependencies();

    @Inject
    public MicronautExtension(ObjectFactory objectFactory, SourceSetConfigurer sourceSetConfigurer) {
        this.processing = (AnnotationProcessing)objectFactory.newInstance(AnnotationProcessing.class, new Object[]{sourceSetConfigurer});
        this.version = objectFactory.property(String.class);
        this.enableNativeImage = objectFactory.property(Boolean.class).convention((Object)true);
        this.runtime = objectFactory.property(MicronautRuntime.class).convention((Object)MicronautRuntime.NONE);
        this.testRuntime = objectFactory.property(MicronautTestRuntime.class).convention((Object)MicronautTestRuntime.NONE);
        this.getImportMicronautPlatform().convention((Object)true);
    }

    public Property<MicronautTestRuntime> getTestRuntime() {
        return this.testRuntime;
    }

    public Property<MicronautRuntime> getRuntime() {
        return this.runtime;
    }

    public Property<Boolean> getEnableNativeImage() {
        return this.enableNativeImage;
    }

    public MicronautExtension enableNativeImage(boolean b) {
        this.enableNativeImage.set((Object)b);
        return this;
    }

    public MicronautExtension version(String version) {
        this.version.set((Object)version);
        return this;
    }

    public MicronautExtension runtime(String runtime) {
        if (runtime != null) {
            this.runtime.set((Object)MicronautRuntime.valueOf(runtime.toUpperCase(Locale.ENGLISH)));
        }
        return this;
    }

    public MicronautExtension runtime(MicronautRuntime micronautRuntime) {
        if (micronautRuntime != null) {
            this.runtime.set((Object)micronautRuntime);
        }
        return this;
    }

    public MicronautExtension testRuntime(String runtime) {
        if (runtime != null) {
            this.testRuntime.set((Object)MicronautTestRuntime.parse(runtime));
        }
        return this;
    }

    public MicronautExtension testRuntime(MicronautTestRuntime testRuntime) {
        if (testRuntime != null) {
            this.testRuntime.set((Object)testRuntime);
        }
        return this;
    }

    public Property<String> getVersion() {
        return this.version;
    }

    public AnnotationProcessing getProcessing() {
        return this.processing;
    }

    public MicronautExtension processing(Action<AnnotationProcessing> processingAction) {
        processingAction.execute((Object)this.getProcessing());
        return this;
    }

    static Map<String, List<String>> mapOf(Object ... values) {
        int len = values.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments should be an even number representing the keys and values");
        }
        LinkedHashMap<String, List<String>> answer = new LinkedHashMap<String, List<String>>(len / 2);
        int i = 0;
        while (i < values.length - 1) {
            answer.put(values[i++].toString(), (List)values[i++]);
        }
        return answer;
    }
}

