/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.AnnotationProcessing;
import io.micronaut.gradle.ApplicationClasspathInspector;
import io.micronaut.gradle.MicronautBasePlugin;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.MicronautKotlinSupport;
import io.micronaut.gradle.MicronautTestRuntime;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.ShadowPluginSupport;
import io.micronaut.gradle.SourceSetConfigurerRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;

public class MicronautComponentPlugin
implements Plugin<Project> {
    private static final String LOMBOK_GROUP_ID = "org.projectlombok";
    private static final String LOMBOK_ARTIFACT_ID = "lombok";
    private static final List<String> SOURCESETS = List.of("main", "test");
    private static final Set<String> CONFIGURATIONS_TO_APPLY_BOMS = Set.of("annotationProcessor", "testAnnotationProcessor", "api", "implementation", "compileOnly");
    public static final String MICRONAUT_BOMS_CONFIGURATION = "micronautBoms";
    public static final String INSPECT_RUNTIME_CLASSPATH_TASK_NAME = "inspectRuntimeClasspath";

    public void apply(Project project) {
        PluginManager plugins = project.getPluginManager();
        plugins.apply(MicronautBasePlugin.class);
        MicronautExtension micronautExtension = (MicronautExtension)project.getExtensions().getByType(MicronautExtension.class);
        TaskContainer tasks = project.getTasks();
        TaskProvider<ApplicationClasspathInspector> inspectRuntimeClasspath = MicronautComponentPlugin.registerInspectRuntimeClasspath(project, tasks);
        this.configureJava(project, tasks);
        this.configureGroovy(project, tasks, micronautExtension);
        MicronautKotlinSupport.whenKotlinSupportPresent(project, MicronautKotlinSupport::configureKotlin);
        this.configureMicronautBom(project, micronautExtension);
        this.configureTesting(project, micronautExtension, inspectRuntimeClasspath);
        ShadowPluginSupport.withShadowPlugin(project, () -> {
            this.configureTesting(project, micronautExtension, inspectRuntimeClasspath);
            ShadowPluginSupport.mergeServiceFiles(project);
        });
        PluginsHelper.registerVersionExtensions(PluginsHelper.KNOWN_VERSION_PROPERTIES, project);
        this.detectAndFixLombokUse(project);
    }

    private void detectAndFixLombokUse(Project project) {
        AtomicBoolean logged = new AtomicBoolean(false);
        project.afterEvaluate(unused -> {
            for (String conf : List.of("annotationProcessor", "testAnnotationProcessor")) {
                ArrayList currentDependencies;
                Optional<Dependency> lombokDependency;
                Configuration annotationProcessor = (Configuration)project.getConfigurations().findByName(conf);
                if (annotationProcessor == null || !(lombokDependency = (currentDependencies = new ArrayList(annotationProcessor.getDependencies())).stream().filter(this::isLombok).findAny()).isPresent() || ((Dependency)currentDependencies.get(0)).equals(lombokDependency.get())) continue;
                ArrayList<Dependency> newDependencies = new ArrayList<Dependency>(currentDependencies.size());
                Dependency lombok = lombokDependency.get();
                newDependencies.add(lombok);
                for (Dependency dependency : currentDependencies) {
                    if (lombok.equals(dependency)) continue;
                    newDependencies.add(dependency);
                }
                annotationProcessor.getDependencies().clear();
                annotationProcessor.getDependencies().addAll(newDependencies);
                if (logged.compareAndSet(false, true)) continue;
                project.getLogger().warn("Detected use of Lombok, which is strongly discouraged. Annotation processors have been reordered to avoid issues.\nConsider using Micronaut Sourcegen instead: https://micronaut-projects.github.io/micronaut-sourcegen/latest/guide/");
            }
        });
    }

    private boolean isLombok(Dependency dependency) {
        ExternalModuleDependency emd;
        return dependency instanceof ExternalModuleDependency && LOMBOK_GROUP_ID.equals((emd = (ExternalModuleDependency)dependency).getGroup()) && LOMBOK_ARTIFACT_ID.equals(emd.getName());
    }

    private void configureTesting(Project project, MicronautExtension micronautExtension, TaskProvider<ApplicationClasspathInspector> inspectRuntimeClasspath) {
        project.getTasks().withType(Test.class).configureEach(t -> {
            t.dependsOn(new Object[]{inspectRuntimeClasspath});
            if (((MicronautTestRuntime)((Object)((Object)micronautExtension.getTestRuntime().get()))).isUsingJunitPlatform()) {
                t.useJUnitPlatform();
            }
        });
        project.afterEvaluate(p -> {
            DependencyHandler dependencyHandler = project.getDependencies();
            MicronautTestRuntime testRuntime = (MicronautTestRuntime)((Object)((Object)micronautExtension.getTestRuntime().get()));
            testRuntime.getDependencies().forEach((scope, dependencies) -> {
                for (String dependency : dependencies) {
                    dependencyHandler.add(scope, (Object)dependency);
                }
            });
            PluginsHelper.applyAdditionalProcessors(p, "annotationProcessor", "testAnnotationProcessor");
        });
    }

    private void configureMicronautBom(Project project, MicronautExtension micronautExtension) {
        Configuration micronautBoms = project.getConfigurations().getByName(MICRONAUT_BOMS_CONFIGURATION);
        PluginsHelper.maybeAddMicronautPlaformBom(project, micronautBoms);
        SourceSetConfigurerRegistry registry = (SourceSetConfigurerRegistry)project.getExtensions().getByType(SourceSetConfigurerRegistry.class);
        HashSet knownSourceSets = new HashSet();
        registry.register(sourceSet -> {
            MicronautComponentPlugin.configureSourceSet(project, sourceSet, micronautBoms);
            knownSourceSets.add(sourceSet);
        });
        project.afterEvaluate(p -> {
            List configurations;
            project.getConfigurations().configureEach(conf -> {
                if (CONFIGURATIONS_TO_APPLY_BOMS.contains(conf.getName())) {
                    conf.extendsFrom(new Configuration[]{micronautBoms});
                }
            });
            ListProperty<SourceSet> additionalSourceSets = micronautExtension.getProcessing().getAdditionalSourceSets();
            if (additionalSourceSets.isPresent() && !(configurations = (List)additionalSourceSets.get()).isEmpty()) {
                for (SourceSet sourceSet : configurations) {
                    if (knownSourceSets.contains(sourceSet)) continue;
                    AnnotationProcessing.showAdditionalSourceSetDeprecationWarning(sourceSet);
                    MicronautComponentPlugin.configureSourceSet(project, sourceSet, micronautBoms);
                }
            }
        });
    }

    private static void configureSourceSet(Project project, SourceSet sourceSet, Configuration micronautBoms) {
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        List<String> both = List.of(implementationConfigurationName, annotationProcessorConfigurationName);
        for (String configuration : both) {
            Configuration conf = (Configuration)project.getConfigurations().findByName(configuration);
            if (conf == null) continue;
            conf.extendsFrom(new Configuration[]{micronautBoms});
        }
        PluginsHelper.configureAnnotationProcessors(project, implementationConfigurationName, annotationProcessorConfigurationName);
    }

    private void configureJava(Project project, TaskContainer tasks) {
        project.afterEvaluate(p -> {
            SourceSetContainer sourceSets = PluginsHelper.findSourceSets(p);
            for (String sourceSetName : SOURCESETS) {
                SourceSet sourceSet = (SourceSet)sourceSets.findByName(sourceSetName);
                if (sourceSet == null) continue;
                String apiConfigurationName = sourceSet.getApiConfigurationName();
                Configuration c = (Configuration)p.getConfigurations().findByName(apiConfigurationName);
                String implementationScope = c != null ? apiConfigurationName : sourceSet.getImplementationConfigurationName();
                String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
                PluginsHelper.configureAnnotationProcessors(project, implementationScope, annotationProcessorConfigurationName);
            }
            tasks.withType(JavaCompile.class).configureEach(javaCompile -> {
                List compilerArgs = javaCompile.getOptions().getCompilerArgs();
                MicronautExtension micronautExtension = (MicronautExtension)p.getExtensions().getByType(MicronautExtension.class);
                AnnotationProcessing processing = micronautExtension.getProcessing();
                boolean isIncremental = (Boolean)processing.getIncremental().getOrElse((Object)true);
                String group = (String)processing.getGroup().getOrElse((Object)p.getGroup().toString());
                String module = (String)processing.getModule().getOrElse((Object)p.getName());
                compilerArgs.add("-parameters");
                if (isIncremental) {
                    List annotations = (List)processing.getAnnotations().getOrElse(Collections.emptyList());
                    compilerArgs.add("-Amicronaut.processing.incremental=true");
                    if (!annotations.isEmpty()) {
                        compilerArgs.add("-Amicronaut.processing.annotations=" + String.join((CharSequence)",", annotations));
                    } else if (!group.isEmpty()) {
                        compilerArgs.add("-Amicronaut.processing.annotations=" + group + ".*");
                    }
                }
                if (!group.isEmpty()) {
                    compilerArgs.add("-Amicronaut.processing.group=" + group);
                    compilerArgs.add("-Amicronaut.processing.module=" + module);
                }
            });
        });
    }

    private void configureGroovy(Project project, TaskContainer tasks, MicronautExtension micronautExtension) {
        project.getPluginManager().withPlugin("groovy", plugin -> {
            tasks.withType(GroovyCompile.class).configureEach(groovyCompile -> groovyCompile.getGroovyOptions().setParameters(true));
            JavaPluginExtension javaPluginExtension = PluginsHelper.javaPluginExtensionOf(project);
            this.configureDefaultGroovySourceSet(project, javaPluginExtension, "compileOnly", "main");
            this.configureDefaultGroovySourceSet(project, javaPluginExtension, "testCompileOnly", "test");
            project.afterEvaluate(p -> {
                DependencyHandler dependencyHandler = project.getDependencies();
                for (String defaultSourceSetName : SOURCESETS) {
                    SourceSet sourceSet = (SourceSet)PluginsHelper.findSourceSets(p).findByName(defaultSourceSetName);
                    if (sourceSet == null) continue;
                    String configName = sourceSet.getCompileOnlyConfigurationName();
                    Optional<File> groovySrcDir = PluginsHelper.findGroovySrcDir(sourceSet);
                    if (!groovySrcDir.isPresent()) continue;
                    dependencyHandler.add(configName, (Object)"io.micronaut:micronaut-inject-groovy");
                }
                ListProperty<SourceSet> additionalSourceSets = micronautExtension.getProcessing().getAdditionalSourceSets();
                if (additionalSourceSets.isPresent()) {
                    List sourceSets = (List)additionalSourceSets.get();
                    for (SourceSet sourceSet : sourceSets) {
                        String configName = sourceSet.getCompileOnlyConfigurationName();
                        Optional<File> groovySrcDir = PluginsHelper.findGroovySrcDir(sourceSet);
                        if (!groovySrcDir.isPresent()) continue;
                        dependencyHandler.add(configName, (Object)"io.micronaut:micronaut-inject-groovy");
                        PluginsHelper.applyAdditionalProcessors(project, configName);
                    }
                }
            });
        });
    }

    private void configureDefaultGroovySourceSet(Project p, JavaPluginExtension javaPluginExtension, String scope, String sourceSetName) {
        SourceSet groovySourceSet = (SourceSet)javaPluginExtension.getSourceSets().findByName(sourceSetName);
        if (groovySourceSet != null) {
            Optional<File> groovySrc = PluginsHelper.findGroovySrcDir(groovySourceSet);
            groovySrc.ifPresent(f -> PluginsHelper.applyAdditionalProcessors(p, scope));
        }
    }

    private static TaskProvider<ApplicationClasspathInspector> registerInspectRuntimeClasspath(Project project, TaskContainer tasks) {
        return tasks.register(INSPECT_RUNTIME_CLASSPATH_TASK_NAME, ApplicationClasspathInspector.class, task -> {
            task.setGroup("build");
            task.setDescription("Performs sanity checks of the runtime classpath to warn about misconfigured builds");
            task.getRuntimeClasspath().from(new Object[]{project.getConfigurations().getByName("runtimeClasspath")});
            task.getResources().from(new Object[]{((SourceSet)PluginsHelper.findSourceSets(project).getByName("main")).getResources()});
            task.getReportFile().set(project.getLayout().getBuildDirectory().file("reports/inspectRuntimeClasspath.txt"));
        });
    }
}

