/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;

public class LenientGradle {
    private static final Map<String, Optional<Class<?>>> CLASSES = new ConcurrentHashMap();

    private LenientGradle() {
    }

    private static Optional<Class<?>> findClass(String name) {
        return CLASSES.computeIfAbsent(name, LenientGradle::loadClass);
    }

    private static Optional<Class<?>> loadClass(String name) {
        try {
            return Optional.of(Class.forName(name));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return Optional.empty();
        }
    }

    public static <T> void ifTypePresent(String typeName, Consumer<? super Class<T>> consumer) {
        LenientGradle.findClass(typeName).ifPresent(c -> consumer.accept((Object)c));
    }

    public static <T> void withType(DomainObjectCollection<T> collection, String name, Action<? super T> consumer) {
        LenientGradle.findClass(name).ifPresent(clazz -> collection.withType(clazz, consumer));
    }
}

