/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.AnnotationProcessingConfigBuilder;
import io.micronaut.gradle.SourceSetConfigurer;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationProcessing
implements AnnotationProcessingConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationProcessing.class);
    private final Property<String> group;
    private final Property<Boolean> incremental;
    private final Property<String> module;
    private final ListProperty<String> annotations;
    private final ListProperty<SourceSet> additionalSourceSets;
    private final SourceSetConfigurer sourceSetConfigurer;

    public static void showAdditionalSourceSetDeprecationWarning(SourceSet sourceSet) {
        LOGGER.warn("Source set '{}' was declared using the additionalSourceSets property. Please use sourceSet(...) instead.", (Object)sourceSet.getName());
    }

    @Inject
    public AnnotationProcessing(ObjectFactory objectFactory, SourceSetConfigurer sourceSetConfigurer) {
        this.incremental = objectFactory.property(Boolean.class).convention((Object)true);
        this.module = objectFactory.property(String.class);
        this.group = objectFactory.property(String.class);
        this.annotations = objectFactory.listProperty(String.class);
        this.additionalSourceSets = objectFactory.listProperty(SourceSet.class);
        this.sourceSetConfigurer = sourceSetConfigurer;
    }

    public Property<String> getGroup() {
        return this.group;
    }

    public Property<Boolean> getIncremental() {
        return this.incremental;
    }

    public Property<String> getModule() {
        return this.module;
    }

    public ListProperty<String> getAnnotations() {
        return this.annotations;
    }

    @Deprecated
    public ListProperty<SourceSet> getAdditionalSourceSets() {
        return this.additionalSourceSets;
    }

    @Override
    public AnnotationProcessingConfigBuilder sourceSets(SourceSet ... sourceSets) {
        this.additionalSourceSets.addAll((Object[])sourceSets);
        for (SourceSet sourceSet : sourceSets) {
            this.sourceSetConfigurer.onSourceSet(sourceSet);
        }
        return this;
    }

    @Override
    public AnnotationProcessingConfigBuilder incremental(boolean incremental) {
        this.incremental.set((Object)incremental);
        return this;
    }

    @Override
    public AnnotationProcessingConfigBuilder module(String name) {
        if (name != null) {
            this.module.set((Object)name);
        }
        return this;
    }

    @Override
    public AnnotationProcessingConfigBuilder group(String name) {
        if (name != null) {
            this.group.set((Object)name);
        }
        return this;
    }

    @Override
    public AnnotationProcessingConfigBuilder annotations(String ... annotations) {
        if (annotations != null) {
            for (String annotation : annotations) {
                if (annotation == null) continue;
                this.annotations.add((Object)annotation);
            }
        }
        return this;
    }
}

