/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.internal;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.provider.Provider;

class VersionCatalogLookupCache
implements AutoCloseable {
    private final AtomicReference<VersionCatalog> oldCatalog = new AtomicReference();
    private final Map<String, Provider<MinimalExternalModuleDependency>> coordsToDependencyProvider = new ConcurrentHashMap<String, Provider<MinimalExternalModuleDependency>>();

    static VersionCatalogLookupCache get() {
        class Holder {
            private static final VersionCatalogLookupCache INSTANCE = new VersionCatalogLookupCache();

            Holder() {
            }
        }
        return Holder.INSTANCE;
    }

    private VersionCatalogLookupCache() {
    }

    void clear() {
        this.oldCatalog.set(null);
        this.coordsToDependencyProvider.clear();
    }

    private void memoize(VersionCatalog catalog) {
        if (this.oldCatalog.compareAndSet(null, catalog)) {
            this.coordsToDependencyProvider.clear();
            ((Stream)catalog.getLibraryAliases().stream().parallel()).forEach(alias -> {
                Optional library = catalog.findLibrary(alias);
                library.ifPresent(lib -> this.coordsToDependencyProvider.put(((MinimalExternalModuleDependency)lib.get()).getModule().toString(), (Provider<MinimalExternalModuleDependency>)lib));
            });
        }
    }

    public Optional<Provider<MinimalExternalModuleDependency>> findDependencyFromCatalog(VersionCatalog catalog, String coordinates) {
        this.memoize(catalog);
        return Optional.ofNullable(this.coordsToDependencyProvider.get(coordinates));
    }

    @Override
    public void close() {
        this.coordsToDependencyProvider.clear();
    }
}

