/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.internal;

import io.micronaut.gradle.internal.AutomaticDependency;
import io.micronaut.gradle.internal.ConfigurableVersionProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Dependencies {
    private static final String DEVELOPMENT_ONLY = "developmentOnly";
    private final List<AutomaticDependency> dependencies;

    private Dependencies(List<AutomaticDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public Map<String, List<AutomaticDependency>> toMap() {
        return this.dependencies.stream().collect(Collectors.groupingBy(AutomaticDependency::configuration));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<AutomaticDependency> dependencies = new ArrayList<AutomaticDependency>();

        public Builder compileOnly(String coordinates) {
            return this.compileOnly(coordinates, null);
        }

        public Builder compileOnly(String coordinates, ConfigurableVersionProperty version) {
            this.dependencies.add(new AutomaticDependency("compileOnly", coordinates, Optional.ofNullable(version)));
            return this;
        }

        public Builder runtimeOnly(String coordinates) {
            return this.runtimeOnly(coordinates, null);
        }

        public Builder runtimeOnly(String coordinates, ConfigurableVersionProperty version) {
            this.dependencies.add(new AutomaticDependency("runtimeOnly", coordinates, Optional.ofNullable(version)));
            return this;
        }

        public Builder developmentOnly(String coordinates) {
            return this.developmentOnly(coordinates, null);
        }

        public Builder developmentOnly(String coordinates, ConfigurableVersionProperty version) {
            this.dependencies.add(new AutomaticDependency(Dependencies.DEVELOPMENT_ONLY, coordinates, Optional.ofNullable(version)));
            return this;
        }

        public Builder implementation(String coordinates) {
            return this.implementation(coordinates, null);
        }

        public Builder implementation(String coordinates, ConfigurableVersionProperty version) {
            this.dependencies.add(new AutomaticDependency("implementation", coordinates, Optional.ofNullable(version)));
            return this;
        }

        public Builder testImplementation(String coordinates) {
            return this.testImplementation(coordinates, null);
        }

        public Builder testImplementation(String coordinates, ConfigurableVersionProperty version) {
            this.dependencies.add(new AutomaticDependency("testImplementation", coordinates, Optional.ofNullable(version)));
            return this;
        }

        public Dependencies build() {
            return new Dependencies(Collections.unmodifiableList(this.dependencies));
        }
    }
}

