/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.internal;

import io.micronaut.gradle.MicronautComponentPlugin;
import io.micronaut.gradle.MicronautExtension;
import io.micronaut.gradle.internal.ConfigurableVersionProperty;
import io.micronaut.gradle.internal.VersionCatalogLookupCache;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;

public record AutomaticDependency(String configuration, String coordinates, Optional<ConfigurableVersionProperty> versionProperty) {
    public void applyTo(Project p) {
        p.getPlugins().withType(MicronautComponentPlugin.class, unused -> {
            p.afterEvaluate(unusedProject -> VersionCatalogLookupCache.get().clear());
            DependencyHandler dependencyHandler = p.getDependencies();
            MicronautExtension micronautExtension = (MicronautExtension)p.getExtensions().getByType(MicronautExtension.class);
            SetProperty<String> ignoredDependencies = micronautExtension.getIgnoredAutomaticDependencies();
            p.getConfigurations().getByName(this.configuration).getDependencies().addAllLater(p.getProviders().provider(() -> {
                VersionCatalog micronautCatalog;
                VersionCatalogLookupCache catalogCache;
                Optional<Provider<MinimalExternalModuleDependency>> dependencyProvider;
                Optional mn;
                Property provider;
                Set ignored = (Set)ignoredDependencies.getOrElse(Set.of());
                if (ignored.contains(this.coordinates)) {
                    return List.of();
                }
                if (this.versionProperty.isPresent() && (provider = (Property)micronautExtension.getExtensions().findByName(this.versionProperty.get().dslName())) != null && provider.isPresent()) {
                    return List.of(dependencyHandler.create((Object)(this.coordinates + ":" + (String)provider.get())));
                }
                VersionCatalogsExtension versionCatalogs = (VersionCatalogsExtension)p.getExtensions().findByType(VersionCatalogsExtension.class);
                if (versionCatalogs != null && (mn = versionCatalogs.find("mn")).isPresent() && (dependencyProvider = (catalogCache = VersionCatalogLookupCache.get()).findDependencyFromCatalog(micronautCatalog = (VersionCatalog)mn.get(), this.coordinates)).isPresent()) {
                    return List.of((Dependency)dependencyProvider.get().get());
                }
                return List.of(dependencyHandler.create((Object)this.coordinates));
            }));
        });
    }

    public AutomaticDependency withConfiguration(String configuration) {
        return new AutomaticDependency(configuration, this.coordinates, this.versionProperty);
    }
}

