/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.MicronautExtension;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum MicronautTestRuntime {
    JUNIT_5(MicronautExtension.mapOf("testImplementation", List.of("org.junit.jupiter:junit-jupiter-api", "io.micronaut.test:micronaut-test-junit5"), "testRuntimeOnly", Collections.singletonList("org.junit.jupiter:junit-jupiter-engine")), true),
    SPOCK_2(MicronautExtension.mapOf("testCompileOnly", Collections.singletonList("io.micronaut:micronaut-inject-groovy"), "testImplementation", List.of("org.spockframework:spock-core", "io.micronaut.test:micronaut-test-spock", "org.apache.groovy:groovy")), true),
    KOTEST_4(MicronautExtension.mapOf("kotlinProcessors", Collections.singletonList("io.micronaut:micronaut-inject-java"), "testImplementation", List.of("io.mockk:mockk", "io.micronaut.test:micronaut-test-kotest", "io.kotest:kotest-assertions-core-jvm"), "testRuntimeOnly", Collections.singletonList("io.kotest:kotest-runner-junit5-jvm")), true),
    KOTEST_5(MicronautExtension.mapOf("kotlinProcessors", Collections.singletonList("io.micronaut:micronaut-inject-java"), "testImplementation", List.of("io.mockk:mockk", "io.micronaut.test:micronaut-test-kotest5", "io.kotest:kotest-assertions-core-jvm"), "testRuntimeOnly", Collections.singletonList("io.kotest:kotest-runner-junit5-jvm")), true),
    NONE;

    private final Map<String, List<String>> implementation;
    private final boolean usesJunitPlatform;

    private MicronautTestRuntime() {
        this.implementation = Collections.singletonMap("implementation", Collections.emptyList());
        this.usesJunitPlatform = false;
    }

    private MicronautTestRuntime(Map<String, List<String>> implementation, boolean usesJunitPlatform) {
        this.implementation = implementation;
        this.usesJunitPlatform = usesJunitPlatform;
    }

    public Map<String, List<String>> getDependencies() {
        return this.implementation;
    }

    public static MicronautTestRuntime parse(String str) {
        if (str != null) {
            switch (str = str.toUpperCase(Locale.ENGLISH)) {
                case "JUNIT": 
                case "JUNIT5": 
                case "JUNIT_5": {
                    return JUNIT_5;
                }
                case "SPOCK": 
                case "SPOCK2": 
                case "SPOCK_2": {
                    return SPOCK_2;
                }
                case "KOTEST": 
                case "KOTEST4": 
                case "KOTEST_4": {
                    return KOTEST_4;
                }
                case "KOTEST5": 
                case "KOTEST_5": {
                    return KOTEST_5;
                }
            }
        }
        return NONE;
    }

    public boolean isUsingJunitPlatform() {
        return this.usesJunitPlatform;
    }
}

