/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.MicronautRuntime;
import io.micronaut.gradle.internal.ConfigurableVersionProperty;
import io.micronaut.gradle.internal.Dependencies;
import java.util.List;
import org.gradle.api.GradleException;

public final class MicronautRuntimeDependencies {
    private static final String GROUP_MICRONAUT = "io.micronaut";
    private static final String ARTIFACT_ID_MICRONAUT_SERVER_NETTY = "micronaut-http-server-netty";
    private static final String GROUP_MICRONAUT_SERVLET = "io.micronaut.servlet";
    private static final String GROUP_MICRONAUT_AWS = "io.micronaut.aws";
    private static final String GROUP_MICRONAUT_GCP = "io.micronaut.gcp";
    private static final String GROUP_GOOGLE_CLOUD_FUNCTIONS = "com.google.cloud.functions";
    private static final String ARTIFACT_ID_FUNCTIONS_FRAMEWORK_API = "functions-framework-api";
    private static final String GROUP_MICRONAUT_ORACLE = "io.micronaut.oraclecloud";
    private static final String ARTIFACT_ID_MICRONAUT_ORACLE_HTTP = "micronaut-oraclecloud-function-http";
    private static final String ARTIFACT_ID_MICRONAUT_ORACLE_HTTP_TEST = "micronaut-oraclecloud-function-http-test";
    private static final String ARTIFACT_ID_MICRONAUT_GCP_FUNCTION_HTTP = "micronaut-gcp-function-http";
    private static final String ARTIFACT_ID_MICRONAUT_GCP_FUNCTION_HTTP_TEST = "micronaut-gcp-function-http-test";
    private static final String GROUP_MICRONAUT_AZURE = "io.micronaut.azure";
    private static final String ARTIFACT_ID_MICRONAUT_AZURE_FUNCTION_HTTP = "micronaut-azure-function-http";
    private static final String ARTIFACT_ID_MICRONAUT_AZURE_FUNCTION_HTTP_TEST = "micronaut-azure-function-http-test";
    private static final String ARTIFACT_ID_MICRONAUT_AWS_CUSTOM_RUNTIME = "micronaut-function-aws-custom-runtime";
    private static final String ARTIFACT_ID_MICRONAUT_AWS_API_PROXY = "micronaut-function-aws-api-proxy";
    private static final String ARTIFACT_ID_MICRONAUT_AWS_API_PROXY_TEST = "micronaut-function-aws-api-proxy-test";
    private static final String ARTIFACT_ID_MICRONAUT_SERVLET_JETTY = "micronaut-http-server-jetty";
    private static final String ARTIFACT_ID_MICRONAUT_SERVLET_TOMCAT = "micronaut-http-server-tomcat";
    private static final String ARTIFACT_ID_MICRONAUT_SERVLET_UNDERTOW = "micronaut-http-server-undertow";
    private static final String ARTIFACT_ID_MICRONAUT_SERVLET_POJA_APACHE = "micronaut-http-poja-apache";
    private static final String ARTIFACT_ID_MICRONAUT_SERVLET_POJA_TEST = "micronaut-http-poja-test";
    private static final ConfigurableVersionProperty AWS_VERSION_PROPERTY = ConfigurableVersionProperty.of("aws");
    private static final ConfigurableVersionProperty AZURE_VERSION_PROPERTY = ConfigurableVersionProperty.of("azure");
    private static final ConfigurableVersionProperty GCP_VERSION_PROPERTY = ConfigurableVersionProperty.of("gcp");
    private static final ConfigurableVersionProperty HTTP_NETTY_VERSION_PROPERTY = ConfigurableVersionProperty.of("httpNetty");
    private static final ConfigurableVersionProperty ORACLECLOUD_VERSION_PROPERTY = ConfigurableVersionProperty.of("oraclecloud");
    private static final ConfigurableVersionProperty SERVLET_VERSION_PROPERTY = ConfigurableVersionProperty.of("servlet");
    private static final String COLON = ":";
    public static final List<ConfigurableVersionProperty> KNOWN_VERSION_PROPERTIES = List.of(AWS_VERSION_PROPERTY, AZURE_VERSION_PROPERTY, GCP_VERSION_PROPERTY, HTTP_NETTY_VERSION_PROPERTY, ORACLECLOUD_VERSION_PROPERTY, SERVLET_VERSION_PROPERTY);

    private MicronautRuntimeDependencies() {
    }

    public static Dependencies findApplicationPluginDependenciesByRuntime(MicronautRuntime runtime) {
        if (runtime.isLambda()) {
            Dependencies.Builder builder = Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautAwsDependency(ARTIFACT_ID_MICRONAUT_AWS_API_PROXY), AWS_VERSION_PROPERTY).developmentOnly(MicronautRuntimeDependencies.micronautAwsDependency(ARTIFACT_ID_MICRONAUT_AWS_API_PROXY_TEST), AWS_VERSION_PROPERTY).testImplementation(MicronautRuntimeDependencies.micronautAwsDependency(ARTIFACT_ID_MICRONAUT_AWS_API_PROXY_TEST), AWS_VERSION_PROPERTY);
            if (runtime.isLambdaProvided()) {
                builder = builder.implementation(MicronautRuntimeDependencies.micronautAwsDependency(ARTIFACT_ID_MICRONAUT_AWS_CUSTOM_RUNTIME), AWS_VERSION_PROPERTY);
            }
            return builder.build();
        }
        if (runtime == MicronautRuntime.ORACLE_FUNCTION) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautOracleDependency(ARTIFACT_ID_MICRONAUT_ORACLE_HTTP), ORACLECLOUD_VERSION_PROPERTY).testImplementation(MicronautRuntimeDependencies.micronautOracleDependency(ARTIFACT_ID_MICRONAUT_ORACLE_HTTP_TEST), ORACLECLOUD_VERSION_PROPERTY).developmentOnly(MicronautRuntimeDependencies.micronautOracleDependency(ARTIFACT_ID_MICRONAUT_ORACLE_HTTP_TEST), ORACLECLOUD_VERSION_PROPERTY).runtimeOnly("com.fnproject.fn:runtime").build();
        }
        if (runtime == MicronautRuntime.GOOGLE_FUNCTION) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautGcpDependency(ARTIFACT_ID_MICRONAUT_GCP_FUNCTION_HTTP), GCP_VERSION_PROPERTY).developmentOnly(MicronautRuntimeDependencies.dependency(GROUP_GOOGLE_CLOUD_FUNCTIONS, ARTIFACT_ID_FUNCTIONS_FRAMEWORK_API)).developmentOnly(MicronautRuntimeDependencies.micronautGcpDependency(ARTIFACT_ID_MICRONAUT_GCP_FUNCTION_HTTP_TEST), GCP_VERSION_PROPERTY).compileOnly(MicronautRuntimeDependencies.dependency(GROUP_GOOGLE_CLOUD_FUNCTIONS, ARTIFACT_ID_FUNCTIONS_FRAMEWORK_API)).testImplementation(MicronautRuntimeDependencies.dependency(GROUP_GOOGLE_CLOUD_FUNCTIONS, ARTIFACT_ID_FUNCTIONS_FRAMEWORK_API)).testImplementation(MicronautRuntimeDependencies.micronautGcpDependency(ARTIFACT_ID_MICRONAUT_GCP_FUNCTION_HTTP_TEST), GCP_VERSION_PROPERTY).build();
        }
        if (runtime == MicronautRuntime.AZURE_FUNCTION) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautAzureDependency(ARTIFACT_ID_MICRONAUT_AZURE_FUNCTION_HTTP), AZURE_VERSION_PROPERTY).implementation("com.microsoft.azure.functions:azure-functions-java-library").developmentOnly(MicronautRuntimeDependencies.micronautAzureDependency(ARTIFACT_ID_MICRONAUT_AZURE_FUNCTION_HTTP_TEST), AZURE_VERSION_PROPERTY).testImplementation(MicronautRuntimeDependencies.micronautAzureDependency(ARTIFACT_ID_MICRONAUT_AZURE_FUNCTION_HTTP_TEST), AZURE_VERSION_PROPERTY).build();
        }
        if (runtime == MicronautRuntime.NETTY) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.dependency(GROUP_MICRONAUT, ARTIFACT_ID_MICRONAUT_SERVER_NETTY), HTTP_NETTY_VERSION_PROPERTY).build();
        }
        if (runtime == MicronautRuntime.TOMCAT) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautServletDependency(ARTIFACT_ID_MICRONAUT_SERVLET_TOMCAT), SERVLET_VERSION_PROPERTY).build();
        }
        if (runtime == MicronautRuntime.JETTY) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautServletDependency(ARTIFACT_ID_MICRONAUT_SERVLET_JETTY), SERVLET_VERSION_PROPERTY).build();
        }
        if (runtime == MicronautRuntime.UNDERTOW) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautServletDependency(ARTIFACT_ID_MICRONAUT_SERVLET_UNDERTOW), SERVLET_VERSION_PROPERTY).build();
        }
        if (runtime == MicronautRuntime.HTTP_POJA) {
            return Dependencies.builder().implementation(MicronautRuntimeDependencies.micronautServletDependency(ARTIFACT_ID_MICRONAUT_SERVLET_POJA_APACHE), SERVLET_VERSION_PROPERTY).testImplementation(MicronautRuntimeDependencies.micronautServletDependency(ARTIFACT_ID_MICRONAUT_SERVLET_POJA_TEST), SERVLET_VERSION_PROPERTY).build();
        }
        if (runtime != MicronautRuntime.NONE) {
            throw new GradleException("Application plugin dependencies not specified for runtime " + runtime.name());
        }
        return Dependencies.builder().build();
    }

    private static String micronautOracleDependency(String artifactId) {
        return MicronautRuntimeDependencies.dependency(GROUP_MICRONAUT_ORACLE, artifactId);
    }

    private static String micronautAwsDependency(String artifactId) {
        return MicronautRuntimeDependencies.dependency(GROUP_MICRONAUT_AWS, artifactId);
    }

    private static String micronautGcpDependency(String artifactId) {
        return MicronautRuntimeDependencies.dependency(GROUP_MICRONAUT_GCP, artifactId);
    }

    private static String micronautAzureDependency(String artifactId) {
        return MicronautRuntimeDependencies.dependency(GROUP_MICRONAUT_AZURE, artifactId);
    }

    private static String micronautServletDependency(String artifactId) {
        return MicronautRuntimeDependencies.dependency(GROUP_MICRONAUT_SERVLET, artifactId);
    }

    private static String dependency(String groupId, String artifactId) {
        return String.join((CharSequence)COLON, groupId, artifactId);
    }
}

