/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import io.micronaut.gradle.docker.DockerBuildStrategy;

public enum MicronautRuntime {
    NONE,
    NETTY,
    TOMCAT,
    JETTY,
    UNDERTOW,
    LAMBDA_JAVA,
    LAMBDA_PROVIDED(DockerBuildStrategy.LAMBDA),
    ORACLE_FUNCTION(DockerBuildStrategy.ORACLE_FUNCTION),
    GOOGLE_FUNCTION,
    AZURE_FUNCTION,
    HTTP_POJA;

    private final DockerBuildStrategy buildStrategy;

    private MicronautRuntime() {
        this.buildStrategy = DockerBuildStrategy.DEFAULT;
    }

    private MicronautRuntime(DockerBuildStrategy buildStrategy) {
        this.buildStrategy = buildStrategy;
    }

    public DockerBuildStrategy getBuildStrategy() {
        return this.buildStrategy;
    }

    public boolean isLambda() {
        return this == LAMBDA_JAVA || this.isLambdaProvided();
    }

    public boolean isLambdaProvided() {
        return this == LAMBDA_PROVIDED;
    }
}

