/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class ApplicationClasspathInspector
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getResources();

    @Internal
    public abstract ConfigurableFileCollection getRuntimeClasspath();

    @Input
    public Set<String> getResolvedClasspathNames() {
        return this.getRuntimeClasspath().getFiles().stream().map(File::getName).collect(Collectors.toSet());
    }

    @OutputFile
    public abstract RegularFileProperty getReportFile();

    @TaskAction
    void inspect() throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(((RegularFile)this.getReportFile().get()).getAsFile()));){
            Set resources = this.getResources().getFiles();
            if (resources.stream().anyMatch(ApplicationClasspathInspector::isYamlConfigurationFile)) {
                writer.println("YAML configuration file detected");
                if (this.getResolvedClasspathNames().stream().noneMatch(n -> n.startsWith("snakeyaml"))) {
                    writer.println("Didn't find snakeyaml on classpath. Failing");
                    throw new RuntimeException("YAML configuration file detected but snakeyaml is not on classpath. Make sure to add a runtimeOnly dependency on snakeyaml, e.g 'runtimeOnly(\"org.yaml:snakeyaml\")'");
                }
            }
        }
    }

    private static boolean isYamlConfigurationFile(File f) {
        return f.getName().startsWith("application") && (f.getName().endsWith(".yml") || f.getName().endsWith(".yaml"));
    }
}

