/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.masterreplica.StatefulRedisUpstreamReplicaConnectionImpl;
import io.lettuce.core.masterreplica.StaticMasterReplicaTopologyProvider;
import io.lettuce.core.masterreplica.UpstreamReplicaChannelWriter;
import io.lettuce.core.masterreplica.UpstreamReplicaConnectionProvider;
import io.lettuce.core.masterreplica.UpstreamReplicaConnector;
import io.lettuce.core.masterreplica.UpstreamReplicaTopologyRefresh;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import reactor.core.publisher.Mono;

class StaticUpstreamReplicaConnector<K, V>
implements UpstreamReplicaConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final Iterable<RedisURI> redisURIs;

    StaticUpstreamReplicaConnector(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURIs = redisURIs;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync() {
        HashMap initialConnections = new HashMap();
        StaticMasterReplicaTopologyProvider topologyProvider = new StaticMasterReplicaTopologyProvider(this.redisClient, this.redisURIs);
        RedisURI seedNode = this.redisURIs.iterator().next();
        UpstreamReplicaTopologyRefresh refresh = new UpstreamReplicaTopologyRefresh(this.redisClient, topologyProvider);
        UpstreamReplicaConnectionProvider<K, V> connectionProvider = new UpstreamReplicaConnectionProvider<K, V>(this.redisClient, this.codec, seedNode, initialConnections);
        return refresh.getNodes(seedNode).flatMap(nodes -> {
            if (nodes.isEmpty()) {
                return Mono.error((Throwable)new RedisException(String.format("Cannot determine topology from %s", this.redisURIs)));
            }
            return this.initializeConnection(this.codec, seedNode, connectionProvider, (List<RedisNodeDescription>)nodes);
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<StatefulRedisMasterReplicaConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, RedisURI seedNode, UpstreamReplicaConnectionProvider<K, V> connectionProvider, List<RedisNodeDescription> nodes) {
        connectionProvider.setKnownNodes(nodes);
        UpstreamReplicaChannelWriter channelWriter = new UpstreamReplicaChannelWriter(connectionProvider, this.redisClient.getResources());
        StatefulRedisUpstreamReplicaConnectionImpl<K, V> connection = new StatefulRedisUpstreamReplicaConnectionImpl<K, V>(channelWriter, codec, seedNode.getTimeout());
        connection.setOptions(this.redisClient.getOptions());
        return Mono.just(connection);
    }
}

