/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ReadFromImpl;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.List;

public abstract class ReadFrom {
    @Deprecated
    public static final ReadFrom MASTER = new ReadFromImpl.ReadFromUpstream();
    @Deprecated
    public static final ReadFrom MASTER_PREFERRED = new ReadFromImpl.ReadFromUpstreamPreferred();
    public static final ReadFrom UPSTREAM = new ReadFromImpl.ReadFromUpstream();
    public static final ReadFrom UPSTREAM_PREFERRED = new ReadFromImpl.ReadFromUpstreamPreferred();
    public static final ReadFrom REPLICA_PREFERRED;
    @Deprecated
    public static final ReadFrom SLAVE_PREFERRED;
    public static final ReadFrom REPLICA;
    @Deprecated
    public static final ReadFrom SLAVE;
    public static final ReadFrom NEAREST;
    public static final ReadFrom ANY;
    public static final ReadFrom ANY_REPLICA;

    public abstract List<RedisNodeDescription> select(Nodes var1);

    protected boolean isOrderSensitive() {
        return false;
    }

    public static ReadFrom valueOf(String name) {
        if (LettuceStrings.isEmpty(name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        if (name.equalsIgnoreCase("master")) {
            return UPSTREAM;
        }
        if (name.equalsIgnoreCase("masterPreferred")) {
            return UPSTREAM_PREFERRED;
        }
        if (name.equalsIgnoreCase("upstream")) {
            return UPSTREAM;
        }
        if (name.equalsIgnoreCase("upstreamPreferred")) {
            return UPSTREAM_PREFERRED;
        }
        if (name.equalsIgnoreCase("slave") || name.equalsIgnoreCase("replica")) {
            return REPLICA;
        }
        if (name.equalsIgnoreCase("slavePreferred") || name.equalsIgnoreCase("replicaPreferred")) {
            return REPLICA_PREFERRED;
        }
        if (name.equalsIgnoreCase("nearest")) {
            return NEAREST;
        }
        if (name.equalsIgnoreCase("any")) {
            return ANY;
        }
        if (name.equalsIgnoreCase("anyReplica")) {
            return ANY_REPLICA;
        }
        throw new IllegalArgumentException("ReadFrom " + name + " not supported");
    }

    static {
        SLAVE_PREFERRED = REPLICA_PREFERRED = new ReadFromImpl.ReadFromReplicaPreferred();
        SLAVE = REPLICA = new ReadFromImpl.ReadFromReplica();
        NEAREST = new ReadFromImpl.ReadFromNearest();
        ANY = new ReadFromImpl.ReadFromAnyNode();
        ANY_REPLICA = new ReadFromImpl.ReadFromAnyReplica();
    }

    public static interface Nodes
    extends Iterable<RedisNodeDescription> {
        public List<RedisNodeDescription> getNodes();
    }
}

