/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.codec;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.ToByteBufEncoder;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.LettuceCharsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class StringCodec
implements RedisCodec<String, String>,
ToByteBufEncoder<String, String> {
    public static final StringCodec UTF8 = new StringCodec(LettuceCharsets.UTF8);
    public static final StringCodec ASCII = new StringCodec(LettuceCharsets.ASCII);
    private static final byte[] EMPTY = new byte[0];
    private final Charset charset;
    private final boolean ascii;
    private final boolean utf8;

    public StringCodec() {
        this(Charset.defaultCharset());
    }

    public StringCodec(Charset charset) {
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        this.charset = charset;
        if (charset.name().equals("UTF-8")) {
            this.utf8 = true;
            this.ascii = false;
        } else if (charset.name().contains("ASCII")) {
            this.utf8 = false;
            this.ascii = true;
        } else {
            this.ascii = false;
            this.utf8 = false;
        }
    }

    @Override
    public void encodeKey(String key, ByteBuf target) {
        this.encode(key, target);
    }

    public void encode(String str, ByteBuf target) {
        if (str == null) {
            return;
        }
        if (this.utf8) {
            ByteBufUtil.writeUtf8((ByteBuf)target, (CharSequence)str);
            return;
        }
        if (this.ascii) {
            ByteBufUtil.writeAscii((ByteBuf)target, (CharSequence)str);
            return;
        }
        CharsetEncoder encoder = CharsetUtil.encoder((Charset)this.charset);
        int length = (int)((double)str.length() * (double)encoder.maxBytesPerChar());
        target.ensureWritable(length);
        try {
            ByteBuffer dstBuf = target.nioBuffer(0, length);
            int pos = dstBuf.position();
            CoderResult cr = encoder.encode(CharBuffer.wrap(str), dstBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(dstBuf)).isUnderflow()) {
                cr.throwException();
            }
            target.writerIndex(target.writerIndex() + dstBuf.position() - pos);
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
    }

    @Override
    public int estimateSize(Object keyOrValue) {
        if (keyOrValue instanceof String) {
            CharsetEncoder encoder = CharsetUtil.encoder((Charset)this.charset);
            return (int)(encoder.averageBytesPerChar() * (float)((String)keyOrValue).length());
        }
        return 0;
    }

    @Override
    public void encodeValue(String value, ByteBuf target) {
        this.encode(value, target);
    }

    @Override
    public String decodeKey(ByteBuffer bytes) {
        return Unpooled.wrappedBuffer((ByteBuffer)bytes).toString(this.charset);
    }

    @Override
    public String decodeValue(ByteBuffer bytes) {
        return Unpooled.wrappedBuffer((ByteBuffer)bytes).toString(this.charset);
    }

    @Override
    public ByteBuffer encodeKey(String key) {
        return this.encodeAndAllocateBuffer(key);
    }

    @Override
    public ByteBuffer encodeValue(String value) {
        return this.encodeAndAllocateBuffer(value);
    }

    private ByteBuffer encodeAndAllocateBuffer(String key) {
        if (key == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        CharsetEncoder encoder = CharsetUtil.encoder((Charset)this.charset);
        ByteBuffer buffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)key.length()));
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer)buffer);
        byteBuf.clear();
        this.encode(key, byteBuf);
        buffer.limit(byteBuf.writerIndex());
        return buffer;
    }
}

