/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.util.RuntimeHttpUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.credentials.Authentication;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EKSAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(EKSAuthentication.class);
    private static final int MAX_EXPIRY_SECONDS = 900;
    private final AWSSessionCredentialsProvider provider;
    private final String region;
    private final String clusterName;
    private final URI stsEndpoint;
    private final int expirySeconds;

    public EKSAuthentication(AWSSessionCredentialsProvider provider, String region, String clusterName) {
        this(provider, region, clusterName, 900);
    }

    public EKSAuthentication(AWSSessionCredentialsProvider provider, String region, String clusterName, int expirySeconds) {
        this.provider = provider;
        this.region = region;
        this.clusterName = clusterName;
        if (expirySeconds > 900) {
            expirySeconds = 900;
        }
        this.expirySeconds = expirySeconds;
        this.stsEndpoint = URI.create("https://sts." + this.region + ".amazonaws.com");
    }

    @Override
    public void provide(ApiClient client) {
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)new GetCallerIdentityRequest(), "sts");
        defaultRequest.setResourcePath("/");
        defaultRequest.setEndpoint(this.stsEndpoint);
        defaultRequest.setHttpMethod(HttpMethodName.GET);
        defaultRequest.addParameter("Action", "GetCallerIdentity");
        defaultRequest.addParameter("Version", "2011-06-15");
        defaultRequest.addHeader("x-k8s-aws-id", this.clusterName);
        AWS4Signer signer = new AWS4Signer();
        Date expirationTime = new Date(Clock.systemDefaultZone().millis() + 60000L);
        signer.setServiceName("sts");
        signer.presignRequest((SignableRequest)defaultRequest, (AWSCredentials)this.provider.getCredentials(), expirationTime);
        String encodedUrl = Base64.getUrlEncoder().withoutPadding().encodeToString(RuntimeHttpUtils.convertRequestToUrl((Request)defaultRequest, (boolean)true, (boolean)false).toString().getBytes(StandardCharsets.UTF_8));
        String token = "k8s-aws-v1." + encodedUrl;
        client.setApiKeyPrefix("Bearer");
        client.setApiKey(token);
        log.info("Generated BEARER token for ApiClient, expiring at {}", (Object)Instant.now().plus((long)this.expirySeconds, ChronoUnit.SECONDS));
    }
}

