/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2ContainerResourceMetricSource;
import io.kubernetes.client.openapi.models.V2ContainerResourceMetricSourceBuilder;
import io.kubernetes.client.openapi.models.V2ContainerResourceMetricSourceFluent;
import io.kubernetes.client.openapi.models.V2ExternalMetricSource;
import io.kubernetes.client.openapi.models.V2ExternalMetricSourceBuilder;
import io.kubernetes.client.openapi.models.V2ExternalMetricSourceFluent;
import io.kubernetes.client.openapi.models.V2MetricSpec;
import io.kubernetes.client.openapi.models.V2ObjectMetricSource;
import io.kubernetes.client.openapi.models.V2ObjectMetricSourceBuilder;
import io.kubernetes.client.openapi.models.V2ObjectMetricSourceFluent;
import io.kubernetes.client.openapi.models.V2PodsMetricSource;
import io.kubernetes.client.openapi.models.V2PodsMetricSourceBuilder;
import io.kubernetes.client.openapi.models.V2PodsMetricSourceFluent;
import io.kubernetes.client.openapi.models.V2ResourceMetricSource;
import io.kubernetes.client.openapi.models.V2ResourceMetricSourceBuilder;
import io.kubernetes.client.openapi.models.V2ResourceMetricSourceFluent;
import java.util.Objects;
import java.util.Optional;

public class V2MetricSpecFluent<A extends V2MetricSpecFluent<A>>
extends BaseFluent<A> {
    private V2ContainerResourceMetricSourceBuilder containerResource;
    private V2ExternalMetricSourceBuilder external;
    private V2ObjectMetricSourceBuilder _object;
    private V2PodsMetricSourceBuilder pods;
    private V2ResourceMetricSourceBuilder resource;
    private String type;

    public V2MetricSpecFluent() {
    }

    public V2MetricSpecFluent(V2MetricSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2MetricSpec instance) {
        V2MetricSpec v2MetricSpec = instance = instance != null ? instance : new V2MetricSpec();
        if (instance != null) {
            this.withContainerResource(instance.getContainerResource());
            this.withExternal(instance.getExternal());
            this.withObject(instance.getObject());
            this.withPods(instance.getPods());
            this.withResource(instance.getResource());
            this.withType(instance.getType());
        }
    }

    public V2ContainerResourceMetricSource buildContainerResource() {
        return this.containerResource != null ? this.containerResource.build() : null;
    }

    public A withContainerResource(V2ContainerResourceMetricSource containerResource) {
        this._visitables.remove("containerResource");
        if (containerResource != null) {
            this.containerResource = new V2ContainerResourceMetricSourceBuilder(containerResource);
            this._visitables.get("containerResource").add(this.containerResource);
        } else {
            this.containerResource = null;
            this._visitables.get("containerResource").remove(this.containerResource);
        }
        return (A)this;
    }

    public boolean hasContainerResource() {
        return this.containerResource != null;
    }

    public ContainerResourceNested<A> withNewContainerResource() {
        return new ContainerResourceNested(null);
    }

    public ContainerResourceNested<A> withNewContainerResourceLike(V2ContainerResourceMetricSource item) {
        return new ContainerResourceNested(item);
    }

    public ContainerResourceNested<A> editContainerResource() {
        return this.withNewContainerResourceLike(Optional.ofNullable(this.buildContainerResource()).orElse(null));
    }

    public ContainerResourceNested<A> editOrNewContainerResource() {
        return this.withNewContainerResourceLike(Optional.ofNullable(this.buildContainerResource()).orElse(new V2ContainerResourceMetricSourceBuilder().build()));
    }

    public ContainerResourceNested<A> editOrNewContainerResourceLike(V2ContainerResourceMetricSource item) {
        return this.withNewContainerResourceLike(Optional.ofNullable(this.buildContainerResource()).orElse(item));
    }

    public V2ExternalMetricSource buildExternal() {
        return this.external != null ? this.external.build() : null;
    }

    public A withExternal(V2ExternalMetricSource external) {
        this._visitables.remove("external");
        if (external != null) {
            this.external = new V2ExternalMetricSourceBuilder(external);
            this._visitables.get("external").add(this.external);
        } else {
            this.external = null;
            this._visitables.get("external").remove(this.external);
        }
        return (A)this;
    }

    public boolean hasExternal() {
        return this.external != null;
    }

    public ExternalNested<A> withNewExternal() {
        return new ExternalNested(null);
    }

    public ExternalNested<A> withNewExternalLike(V2ExternalMetricSource item) {
        return new ExternalNested(item);
    }

    public ExternalNested<A> editExternal() {
        return this.withNewExternalLike(Optional.ofNullable(this.buildExternal()).orElse(null));
    }

    public ExternalNested<A> editOrNewExternal() {
        return this.withNewExternalLike(Optional.ofNullable(this.buildExternal()).orElse(new V2ExternalMetricSourceBuilder().build()));
    }

    public ExternalNested<A> editOrNewExternalLike(V2ExternalMetricSource item) {
        return this.withNewExternalLike(Optional.ofNullable(this.buildExternal()).orElse(item));
    }

    public V2ObjectMetricSource buildObject() {
        return this._object != null ? this._object.build() : null;
    }

    public A withObject(V2ObjectMetricSource _object) {
        this._visitables.remove("_object");
        if (_object != null) {
            this._object = new V2ObjectMetricSourceBuilder(_object);
            this._visitables.get("_object").add(this._object);
        } else {
            this._object = null;
            this._visitables.get("_object").remove(this._object);
        }
        return (A)this;
    }

    public boolean hasObject() {
        return this._object != null;
    }

    public ObjectNested<A> withNewObject() {
        return new ObjectNested(null);
    }

    public ObjectNested<A> withNewObjectLike(V2ObjectMetricSource item) {
        return new ObjectNested(item);
    }

    public ObjectNested<A> editObject() {
        return this.withNewObjectLike(Optional.ofNullable(this.buildObject()).orElse(null));
    }

    public ObjectNested<A> editOrNewObject() {
        return this.withNewObjectLike(Optional.ofNullable(this.buildObject()).orElse(new V2ObjectMetricSourceBuilder().build()));
    }

    public ObjectNested<A> editOrNewObjectLike(V2ObjectMetricSource item) {
        return this.withNewObjectLike(Optional.ofNullable(this.buildObject()).orElse(item));
    }

    public V2PodsMetricSource buildPods() {
        return this.pods != null ? this.pods.build() : null;
    }

    public A withPods(V2PodsMetricSource pods) {
        this._visitables.remove("pods");
        if (pods != null) {
            this.pods = new V2PodsMetricSourceBuilder(pods);
            this._visitables.get("pods").add(this.pods);
        } else {
            this.pods = null;
            this._visitables.get("pods").remove(this.pods);
        }
        return (A)this;
    }

    public boolean hasPods() {
        return this.pods != null;
    }

    public PodsNested<A> withNewPods() {
        return new PodsNested(null);
    }

    public PodsNested<A> withNewPodsLike(V2PodsMetricSource item) {
        return new PodsNested(item);
    }

    public PodsNested<A> editPods() {
        return this.withNewPodsLike(Optional.ofNullable(this.buildPods()).orElse(null));
    }

    public PodsNested<A> editOrNewPods() {
        return this.withNewPodsLike(Optional.ofNullable(this.buildPods()).orElse(new V2PodsMetricSourceBuilder().build()));
    }

    public PodsNested<A> editOrNewPodsLike(V2PodsMetricSource item) {
        return this.withNewPodsLike(Optional.ofNullable(this.buildPods()).orElse(item));
    }

    public V2ResourceMetricSource buildResource() {
        return this.resource != null ? this.resource.build() : null;
    }

    public A withResource(V2ResourceMetricSource resource) {
        this._visitables.remove("resource");
        if (resource != null) {
            this.resource = new V2ResourceMetricSourceBuilder(resource);
            this._visitables.get("resource").add(this.resource);
        } else {
            this.resource = null;
            this._visitables.get("resource").remove(this.resource);
        }
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public ResourceNested<A> withNewResource() {
        return new ResourceNested(null);
    }

    public ResourceNested<A> withNewResourceLike(V2ResourceMetricSource item) {
        return new ResourceNested(item);
    }

    public ResourceNested<A> editResource() {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(null));
    }

    public ResourceNested<A> editOrNewResource() {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(new V2ResourceMetricSourceBuilder().build()));
    }

    public ResourceNested<A> editOrNewResourceLike(V2ResourceMetricSource item) {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2MetricSpecFluent that = (V2MetricSpecFluent)o;
        if (!Objects.equals(this.containerResource, that.containerResource)) {
            return false;
        }
        if (!Objects.equals(this.external, that.external)) {
            return false;
        }
        if (!Objects.equals(this._object, that._object)) {
            return false;
        }
        if (!Objects.equals(this.pods, that.pods)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerResource, this.external, this._object, this.pods, this.resource, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerResource != null) {
            sb.append("containerResource:");
            sb.append(String.valueOf(this.containerResource) + ",");
        }
        if (this.external != null) {
            sb.append("external:");
            sb.append(String.valueOf(this.external) + ",");
        }
        if (this._object != null) {
            sb.append("_object:");
            sb.append(String.valueOf(this._object) + ",");
        }
        if (this.pods != null) {
            sb.append("pods:");
            sb.append(String.valueOf(this.pods) + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(String.valueOf(this.resource) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ContainerResourceNested<N>
    extends V2ContainerResourceMetricSourceFluent<ContainerResourceNested<N>>
    implements Nested<N> {
        V2ContainerResourceMetricSourceBuilder builder;

        ContainerResourceNested(V2ContainerResourceMetricSource item) {
            this.builder = new V2ContainerResourceMetricSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2MetricSpecFluent.this.withContainerResource(this.builder.build());
        }

        public N endContainerResource() {
            return this.and();
        }
    }

    public class ExternalNested<N>
    extends V2ExternalMetricSourceFluent<ExternalNested<N>>
    implements Nested<N> {
        V2ExternalMetricSourceBuilder builder;

        ExternalNested(V2ExternalMetricSource item) {
            this.builder = new V2ExternalMetricSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2MetricSpecFluent.this.withExternal(this.builder.build());
        }

        public N endExternal() {
            return this.and();
        }
    }

    public class ObjectNested<N>
    extends V2ObjectMetricSourceFluent<ObjectNested<N>>
    implements Nested<N> {
        V2ObjectMetricSourceBuilder builder;

        ObjectNested(V2ObjectMetricSource item) {
            this.builder = new V2ObjectMetricSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2MetricSpecFluent.this.withObject(this.builder.build());
        }

        public N endObject() {
            return this.and();
        }
    }

    public class PodsNested<N>
    extends V2PodsMetricSourceFluent<PodsNested<N>>
    implements Nested<N> {
        V2PodsMetricSourceBuilder builder;

        PodsNested(V2PodsMetricSource item) {
            this.builder = new V2PodsMetricSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2MetricSpecFluent.this.withPods(this.builder.build());
        }

        public N endPods() {
            return this.and();
        }
    }

    public class ResourceNested<N>
    extends V2ResourceMetricSourceFluent<ResourceNested<N>>
    implements Nested<N> {
        V2ResourceMetricSourceBuilder builder;

        ResourceNested(V2ResourceMetricSource item) {
            this.builder = new V2ResourceMetricSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2MetricSpecFluent.this.withResource(this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }
}

