/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="MetricIdentifier defines the name and optionally selector for a metric")
public class V2MetricIdentifier {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    @Nullable
    private V1LabelSelector selector;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2MetricIdentifier name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name is the name of the given metric")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V2MetricIdentifier selector(@Nullable V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(@Nullable V1LabelSelector selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2MetricIdentifier v2MetricIdentifier = (V2MetricIdentifier)o;
        return Objects.equals(this.name, v2MetricIdentifier.name) && Objects.equals(this.selector, v2MetricIdentifier.selector);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2MetricIdentifier {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2MetricIdentifier is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2MetricIdentifier` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SELECTOR));
        }
    }

    public static V2MetricIdentifier fromJson(String jsonString) throws IOException {
        return (V2MetricIdentifier)JSON.getGson().fromJson(jsonString, V2MetricIdentifier.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2MetricIdentifier.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2MetricIdentifier.class));
            return new TypeAdapter<V2MetricIdentifier>(){

                public void write(JsonWriter out, V2MetricIdentifier value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2MetricIdentifier read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2MetricIdentifier.validateJsonElement(jsonElement);
                    return (V2MetricIdentifier)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

