/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfig;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfigBuilder;
import io.kubernetes.client.openapi.models.ApiextensionsV1WebhookClientConfigFluent;
import io.kubernetes.client.openapi.models.V1WebhookConversion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1WebhookConversionFluent<A extends V1WebhookConversionFluent<A>>
extends BaseFluent<A> {
    private ApiextensionsV1WebhookClientConfigBuilder clientConfig;
    private List<String> conversionReviewVersions;

    public V1WebhookConversionFluent() {
    }

    public V1WebhookConversionFluent(V1WebhookConversion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1WebhookConversion instance) {
        V1WebhookConversion v1WebhookConversion = instance = instance != null ? instance : new V1WebhookConversion();
        if (instance != null) {
            this.withClientConfig(instance.getClientConfig());
            this.withConversionReviewVersions(instance.getConversionReviewVersions());
        }
    }

    public ApiextensionsV1WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    public A withClientConfig(ApiextensionsV1WebhookClientConfig clientConfig) {
        this._visitables.remove("clientConfig");
        if (clientConfig != null) {
            this.clientConfig = new ApiextensionsV1WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        } else {
            this.clientConfig = null;
            this._visitables.get("clientConfig").remove(this.clientConfig);
        }
        return (A)this;
    }

    public boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    public ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNested(null);
    }

    public ClientConfigNested<A> withNewClientConfigLike(ApiextensionsV1WebhookClientConfig item) {
        return new ClientConfigNested(item);
    }

    public ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(null));
    }

    public ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(new ApiextensionsV1WebhookClientConfigBuilder().build()));
    }

    public ClientConfigNested<A> editOrNewClientConfigLike(ApiextensionsV1WebhookClientConfig item) {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(item));
    }

    public A addToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
            this._visitables.remove("conversionReviewVersions");
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1WebhookConversionFluent that = (V1WebhookConversionFluent)o;
        if (!Objects.equals(this.clientConfig, that.clientConfig)) {
            return false;
        }
        return Objects.equals(this.conversionReviewVersions, that.conversionReviewVersions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientConfig, this.conversionReviewVersions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientConfig != null) {
            sb.append("clientConfig:");
            sb.append(String.valueOf(this.clientConfig) + ",");
        }
        if (this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty()) {
            sb.append("conversionReviewVersions:");
            sb.append(this.conversionReviewVersions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientConfigNested<N>
    extends ApiextensionsV1WebhookClientConfigFluent<ClientConfigNested<N>>
    implements Nested<N> {
        ApiextensionsV1WebhookClientConfigBuilder builder;

        ClientConfigNested(ApiextensionsV1WebhookClientConfig item) {
            this.builder = new ApiextensionsV1WebhookClientConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1WebhookConversionFluent.this.withClientConfig(this.builder.build());
        }

        public N endClientConfig() {
            return this.and();
        }
    }
}

